package com.gingersoft.supply_chain.mvp.presenter;

import android.app.Application;

import com.gingersoft.supply_chain.mvp.bean.ConsumeReasonBean;
import com.gingersoft.supply_chain.mvp.content.SupplyShoppingCart;
import com.gingersoft.supply_chain.mvp.ui.adapter.ConsumptionReasonAdapter;
import com.gingersoft.supply_chain.mvp.ui.adapter.WareHousingOrderFoodAdapter;
import com.jess.arms.integration.AppManager;
import com.jess.arms.di.scope.FragmentScope;
import com.jess.arms.mvp.BasePresenter;
import com.jess.arms.http.imageloader.ImageLoader;

import me.jessyan.rxerrorhandler.core.RxErrorHandler;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.WarehousingOrderDetailsContract;

import java.util.ArrayList;
import java.util.List;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/29/2021 15:05
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@FragmentScope
public class WarehousingOrderDetailsPresenter extends BasePresenter<WarehousingOrderDetailsContract.Model, WarehousingOrderDetailsContract.View> {
    @Inject
    RxErrorHandler mErrorHandler;
    @Inject
    Application mApplication;
    @Inject
    ImageLoader mImageLoader;
    @Inject
    AppManager mAppManager;
    private ConsumptionReasonAdapter consumptionReasonAdapter;
    private WareHousingOrderFoodAdapter wareHousingOrderFoodAdapter;

    @Inject
    public WarehousingOrderDetailsPresenter(WarehousingOrderDetailsContract.Model model, WarehousingOrderDetailsContract.View rootView) {
        super(model, rootView);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mErrorHandler = null;
        this.mAppManager = null;
        this.mImageLoader = null;
        this.mApplication = null;
    }


    public void getWarehousingReason() {
        List<ConsumeReasonBean> consumeReasonBeans = new ArrayList<>();
        consumptionReasonAdapter = new ConsumptionReasonAdapter(consumeReasonBeans);
        mRootView.initReason(consumptionReasonAdapter);
    }

    public void getWarehousingFood() {
        if (wareHousingOrderFoodAdapter == null) {
            wareHousingOrderFoodAdapter = new WareHousingOrderFoodAdapter(SupplyShoppingCart.getInstance().getCartFoods());
            mRootView.initFoodView(wareHousingOrderFoodAdapter);
        } else {
            wareHousingOrderFoodAdapter.setNewInstance(SupplyShoppingCart.getInstance().getCartFoods());
        }
    }
}
