package com.gingersoft.supply_chain.mvp.ui.adapter;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodBean;

import org.jetbrains.annotations.NotNull;

import java.util.List;

/**
 * @author 宇航. 1239658231@qq.com
 * User: admin
 * Date: 2021/4/30
 * Time: 9:20
 * Use:
 */
public class WareHousingOrderFoodAdapter extends BaseQuickAdapter<PurchaseFoodBean, BaseViewHolder> {

    public WareHousingOrderFoodAdapter(@Nullable List<PurchaseFoodBean> data) {
        super(R.layout.item_warehousing_order_details, data);
        addChildClickViewIds(R.id.tv_edit);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder holder, PurchaseFoodBean item) {
        holder.setText(R.id.tv_goods_name, item.getName());
        holder.setText(R.id.tv_goods_unit, item.getBasicUnitName());
        holder.setText(R.id.tv_goods_quantity, String.valueOf(item.getFoodQuantity()));
        holder.setText(R.id.tv_edit, getContext().getString(R.string.str_look_over));
        if (item.getFoodUnits() != null && item.getFoodUnits().size() > 1) {
            holder.setVisible(R.id.iv_switch_unit, true);
        } else {
            holder.setGone(R.id.iv_switch_unit, true);
        }
    }
}
