package com.gingersoft.supply_chain.mvp.ui.fragment.warehouse;

import android.os.Bundle;
import android.os.UserManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.common.core.user.UserConstans;
import com.gingersoft.gsa.cloud.common.core.user.UserContext;
import com.gingersoft.gsa.cloud.common.core.user.info.UserInfo;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.ui.animator.CustomAnimation1;
import com.gingersoft.gsa.cloud.ui.animator.CustomAnimation3;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.di.component.DaggerWarehousingOrderListComponent;
import com.gingersoft.supply_chain.mvp.bean.WarehouseOrderBean;
import com.gingersoft.supply_chain.mvp.content.SupplyShoppingCart;
import com.gingersoft.supply_chain.mvp.contract.WarehousingOrderListContract;
import com.gingersoft.supply_chain.mvp.presenter.WarehousingOrderListPresenter;
import com.gingersoft.supply_chain.mvp.ui.adapter.WarehousingOrderListAdapter;
import com.gingersoft.supply_chain.mvp.ui.fragment.BaseSupplyChainFragment;
import com.gingersoft.supply_chain.mvp.ui.fragment.food.BuyIngredientsFragment;
import com.jess.arms.di.component.AppComponent;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.gingersoft.supply_chain.mvp.ui.fragment.food.FoodIngredientsFragment.FOOD_INGREDIENTS;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/28/2021 19:21
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class WarehousingOrderListFragment extends BaseSupplyChainFragment<WarehousingOrderListPresenter> implements WarehousingOrderListContract.View, View.OnClickListener {

    @BindView(R2.id.supply_top_bar)
    QMUITopBar supplyTopBar;
    @BindView(R2.id.rv_second_category)
    RecyclerView rvSecondCategory;

    public static WarehousingOrderListFragment newInstance() {
        WarehousingOrderListFragment fragment = new WarehousingOrderListFragment();
        return fragment;
    }

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerWarehousingOrderListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_warehousing_list, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        initTopBar(supplyTopBar, "入庫單");
        supplyTopBar.addRightImageButton(R.drawable.ic_circle_new_food_ingredient, R.id.topbar_right_add_button).setOnClickListener(this);
        List<WarehouseOrderBean> warehouseOrderBeanList = new ArrayList<>();
        for (int i = 0; i < 15; i++) {
            warehouseOrderBeanList.add(new WarehouseOrderBean("RKO1101" + i, UserContext.newInstance().getMemberName(), TimeUtils.getCurrentDate(TimeUtils.DEFAULT_DATE_FORMAT_YMDHM), "巴西肥牛", 1, "調撥入庫"));
        }
        WarehousingOrderListAdapter adapter = new WarehousingOrderListAdapter(warehouseOrderBeanList);
        adapter.setAdapterAnimation(new CustomAnimation3());
        rvSecondCategory.setAdapter(adapter);
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        if (viewId == R.id.topbar_right_add_button) {
            //先清空購物車
            SupplyShoppingCart.getInstance().clear();
            //新增入庫單
            start(BuyIngredientsFragment.newInstance(BuyIngredientsFragment.GET_FOOD_BY_WAREHOUSING_ORDER));
        }
    }
}
