package com.gingersoft.gsa.cloud.ui.view;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.bean.SectionHeader;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

import androidx.annotation.Nullable;

/**
 * Created by Wyh on 2020/1/10.
 */
public class BaseTextSectionAdapter extends LinearLayout {

    private TextView mTitleTv;

    public BaseTextSectionAdapter(Context context) {
        this(context, null);
    }

    public BaseTextSectionAdapter(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        setOrientation(LinearLayout.HORIZONTAL);
        setGravity(Gravity.CENTER_VERTICAL);
        setBackgroundColor(Color.WHITE);
        int paddingHor = QMUIDisplayHelper.dp2px(context, 5);
        int paddingVer = QMUIDisplayHelper.dp2px(context, 5);
        mTitleTv = new TextView(getContext());
        mTitleTv.setTextSize(14);
        mTitleTv.setTypeface(Typeface.DEFAULT_BOLD);
        mTitleTv.setTextColor(getColor(context, R.color.theme_color));
        mTitleTv.setPadding(paddingHor, paddingVer, paddingHor, paddingVer);
        addView(mTitleTv, new LayoutParams(0, ViewGroup.LayoutParams.WRAP_CONTENT, 1f));
        setBackgroundColor(getColor(context, R.color.main_home_function_head_bg));
    }

    private int getColor(Context context, int colorId) {
        return context.getResources().getColor(colorId);
    }

//    public ImageView getArrowView() {
//        return mArrowView;
//    }

    public void render(SectionHeader header, boolean isFold) {
        mTitleTv.setText(header.getText());
    }
//
//    @Override
//    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
//        super.onMeasure(widthMeasureSpec,  MeasureSpec.makeMeasureSpec(headerHeight, MeasureSpec.EXACTLY));
//    }
}