package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Function;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "FUNCTION".
*/
public class FunctionDao extends AbstractDao<Function, Long> {

    public static final String TABLENAME = "FUNCTION";

    /**
     * Properties of entity Function.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Dbid = new Property(0, Long.class, "dbid", true, "_id");
        public final static Property Id = new Property(1, Long.class, "id", false, "ID");
        public final static Property Status = new Property(2, int.class, "status", false, "STATUS");
        public final static Property EffectiveTime = new Property(3, long.class, "effectiveTime", false, "EFFECTIVE_TIME");
        public final static Property ResName = new Property(4, String.class, "resName", false, "RES_NAME");
        public final static Property ResUrl = new Property(5, String.class, "resUrl", false, "RES_URL");
        public final static Property ImageURL = new Property(6, String.class, "imageURL", false, "IMAGE_URL");
    }


    public FunctionDao(DaoConfig config) {
        super(config);
    }
    
    public FunctionDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"FUNCTION\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: dbid
                "\"ID\" INTEGER NOT NULL ," + // 1: id
                "\"STATUS\" INTEGER NOT NULL ," + // 2: status
                "\"EFFECTIVE_TIME\" INTEGER NOT NULL ," + // 3: effectiveTime
                "\"RES_NAME\" TEXT," + // 4: resName
                "\"RES_URL\" TEXT," + // 5: resUrl
                "\"IMAGE_URL\" TEXT);"); // 6: imageURL
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"FUNCTION\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Function entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getId());
        stmt.bindLong(3, entity.getStatus());
        stmt.bindLong(4, entity.getEffectiveTime());
 
        String resName = entity.getResName();
        if (resName != null) {
            stmt.bindString(5, resName);
        }
 
        String resUrl = entity.getResUrl();
        if (resUrl != null) {
            stmt.bindString(6, resUrl);
        }
 
        String imageURL = entity.getImageURL();
        if (imageURL != null) {
            stmt.bindString(7, imageURL);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Function entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getId());
        stmt.bindLong(3, entity.getStatus());
        stmt.bindLong(4, entity.getEffectiveTime());
 
        String resName = entity.getResName();
        if (resName != null) {
            stmt.bindString(5, resName);
        }
 
        String resUrl = entity.getResUrl();
        if (resUrl != null) {
            stmt.bindString(6, resUrl);
        }
 
        String imageURL = entity.getImageURL();
        if (imageURL != null) {
            stmt.bindString(7, imageURL);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Function readEntity(Cursor cursor, int offset) {
        Function entity = new Function( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // dbid
            cursor.getLong(offset + 1), // id
            cursor.getInt(offset + 2), // status
            cursor.getLong(offset + 3), // effectiveTime
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // resName
            cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5), // resUrl
            cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6) // imageURL
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Function entity, int offset) {
        entity.setDbid(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setId(cursor.getLong(offset + 1));
        entity.setStatus(cursor.getInt(offset + 2));
        entity.setEffectiveTime(cursor.getLong(offset + 3));
        entity.setResName(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setResUrl(cursor.isNull(offset + 5) ? null : cursor.getString(offset + 5));
        entity.setImageURL(cursor.isNull(offset + 6) ? null : cursor.getString(offset + 6));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Function entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Function entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Function entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
