package com.gingersoft.gsa.cloud.download.mvp.ui.adapter;

import android.content.Context;
import android.view.View;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.TextView;
import com.gingersoft.gsa.cloud.download.R;
import com.gingersoft.gsa.cloud.download.R2;
import com.gingersoft.gsa.cloud.download.mvp.model.bean.DataDownLoadState;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;
import java.util.List;
import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class DataDownLoadAdapter extends DefaultAdapter<DataDownLoadState> {

    private Context mContext;

    public DataDownLoadAdapter(Context context, List<DataDownLoadState> infos) {
        super(infos);
        this.mContext = context;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<DataDownLoadState> getHolder(View v, int viewType) {
        return new DataDownLoadItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.download_data_item_download_list;
    }

    class DataDownLoadItemHolder extends BaseHolder<DataDownLoadState> {

        @BindView(R2.id.iv_state)
        ImageView iv_state;
        @BindView(R2.id.tv_title)
        TextView tv_title;
        @BindView(R2.id.pb_progress)
        ProgressBar pb_progress;

        public DataDownLoadItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(DataDownLoadState dataDownLoadState, int position) {

            tv_title.setText(dataDownLoadState.getText());

            switch (dataDownLoadState.getState()) {
                case 0:
                    iv_state.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_down_load_wait));
                    pb_progress.setVisibility(View.GONE);
                    break;
                case 1:
                    iv_state.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_down_load_download2));
                    pb_progress.setVisibility(View.VISIBLE);
                    break;
                case 2:
                    iv_state.setImageDrawable(mContext.getResources().getDrawable(R.drawable.ic_down_load_success2));
                    pb_progress.setVisibility(View.GONE);
                    break;
            }
        }

    }
}
