package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import com.chad.library.adapter.base.entity.node.BaseExpandNode;
import com.chad.library.adapter.base.entity.node.BaseNode;

import org.jetbrains.annotations.Nullable;

import java.util.ArrayList;
import java.util.List;

public class DishesGroupNode extends BaseExpandNode{
    private int id;
    private int parentId;
    private int restaurantId;
    private boolean isParent;
    private int seqNo;
    private String foodName;

    private List<DishNode> child;
    private List<BaseNode> childNode;

    public DishesGroupNode(int id, int parentId, int restaurantId, boolean isParent, int seqNo, String foodName) {
        this.id = id;
        this.parentId = parentId;
        this.restaurantId = restaurantId;
        this.isParent = isParent;
        this.seqNo = seqNo;
        this.foodName = foodName;
    }


    public List<DishNode> getDishNodes() {
        return child;
    }

    public void setDishNodes(List<DishNode> dishNodes) {
        this.child = dishNodes;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getParentId() {
        return parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public int getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(int restaurantId) {
        this.restaurantId = restaurantId;
    }

    public boolean isParent() {
        return isParent;
    }

    public void setParent(boolean parent) {
        isParent = parent;
    }

    public int getSeqNo() {
        return seqNo;
    }

    public void setSeqNo(int seqNo) {
        this.seqNo = seqNo;
    }

    public String getFoodName() {
        return foodName;
    }

    public void setFoodName(String foodName) {
        this.foodName = foodName;
    }

    public void setChildNode(List<BaseNode> childNode) {
        this.childNode = childNode;
    }

    public DishesGroupNode(List<BaseNode> childNode) {
        this.childNode = childNode;
        setExpanded(false);
    }
    public void addChildNode(BaseNode baseNode) {
        if (baseNode == null) {
            return;
        }
        if (childNode == null) {
            childNode = new ArrayList<>();
        }
        childNode.add(baseNode);
    }

    public String getTitle() {
        return foodName;
    }

    @Override
    public String toString() {
        return "DishesGroupNode{" +
                "id=" + id +
                ", parentId=" + parentId +
                ", restaurantId=" + restaurantId +
                ", isParent=" + isParent +
                ", seqNo=" + seqNo +
                ", foodName='" + foodName + '\'' +
                ", childNode=" + childNode +
                '}';
    }

    @Nullable
    @Override
    public List<BaseNode> getChildNode() {
        if (childNode == null) {
            childNode=new ArrayList<>();
        }
        if ( child != null) {
            childNode.addAll(child);
        }
        return childNode;
    }

}
