/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposdevice.commbox;

import com.epson.eposdevice.EposException;
import com.epson.eposdevice.commbox.GetCommHistoryListener;
import com.epson.eposdevice.commbox.NativeCommBox;
import com.epson.eposdevice.commbox.ReceiveListener;
import com.epson.eposdevice.commbox.SendDataListener;
import java.util.ArrayList;
import java.util.HashMap;

public abstract class CommBox
extends NativeCommBox {
    private long mCommBoxHandle = 0L;
    private ReceiveListener mReceiveListener = null;

    private void OnCommBoxReceive(String ipAddress, String senderId, String receiverId, String message) {
        if (null != this.mReceiveListener) {
            this.outputBoxLogEvent("onCommBoxReceive", ipAddress, senderId, receiverId, message);
            this.mReceiveListener.onCommBoxReceive(ipAddress, senderId, receiverId, message);
        }
    }

    protected CommBox(long handle) {
        this.mCommBoxHandle = handle;
    }

    protected long getInnerHandle() {
        return this.mCommBoxHandle;
    }

    protected void innerDeleteInstance() {
        this.mCommBoxHandle = 0L;
    }

    public void getCommHistory(int[] sequence, GetCommHistoryListener target) throws EposException {
        this.outputBoxLogCallFunction("getCommHistory", target);
        try {
            if (this.mCommBoxHandle == 0L) {
                throw new EposException(5);
            }
            if (target == null || sequence == null || sequence.length == 0) {
                throw new EposException(1);
            }
            long[] sequenceBuf = new long[1];
            int errState = this.nativeCommBoxGetHistory(this.mCommBoxHandle, sequenceBuf, new CommBoxHistoryCallbackAdapter(target));
            if (errState != 0) {
                throw new EposException(errState);
            }
            sequence[0] = (int)sequenceBuf[0];
        }
        catch (EposException ex) {
            this.outputBoxException("getCommHistory", ex);
            throw ex;
        }
        this.outputBoxLogReturnFunction("getCommHistory", target);
    }

    public void sendData(String message, String memberId, int[] sequence, SendDataListener target) throws EposException {
        this.outputBoxLogCallFunction("sendData", message, memberId, sequence, target);
        try {
            if (this.mCommBoxHandle == 0L) {
                throw new EposException(5);
            }
            if (message == null || target == null || sequence == null || sequence.length == 0) {
                throw new EposException(1);
            }
            long[] sequenceBuf = new long[1];
            int errState = this.nativeCommBoxSendData(this.mCommBoxHandle, message, memberId, sequenceBuf, new CommBoxSendDataCallbackAdapter(target));
            if (errState != 0) {
                throw new EposException(errState);
            }
            sequence[0] = (int)sequenceBuf[0];
        }
        catch (EposException ex) {
            this.outputBoxException("sendData", ex);
            throw ex;
        }
        this.outputBoxLogReturnFunction("sendData", message, memberId, sequence, target);
    }

    public void setReceiveEventCallback(ReceiveListener target) {
        if (this.mCommBoxHandle == 0L) {
            return;
        }
        if (target != null) {
            this.mReceiveListener = target;
            this.nativeSetCommBoxReceiveEventCallback(this.mCommBoxHandle, this);
        } else {
            this.nativeSetCommBoxReceiveEventCallback(this.mCommBoxHandle, null);
            this.mReceiveListener = null;
        }
    }

    @Override
    protected void nativeOnCommBoxReceive(long commBoxHandle, String ipAddress, String senderId, String receiverId, String message) {
        this.OnCommBoxReceive(ipAddress, senderId, receiverId, message);
    }

    protected abstract void outputBoxLogCallFunction(String var1, Object ... var2);

    protected abstract void outputBoxLogReturnFunction(String var1, Object ... var2);

    protected abstract void outputBoxException(String var1, Exception var2);

    protected abstract void outputBoxLogEvent(String var1, Object ... var2);

    protected class CommBoxSendDataCallbackAdapter
    implements NativeCommBox.NativeCommBoxSendDataCallbackAdapter {
        private SendDataListener mListener = null;

        public CommBoxSendDataCallbackAdapter(SendDataListener target) {
            this.mListener = target;
        }

        @Override
        public void onCommBoxSendData(long commBoxHandle, String ipAddress, int code, long count, long sequence) {
            if (this.mListener != null) {
                CommBox.this.outputBoxLogEvent("onCommBoxSendData", ipAddress, code, count, sequence);
                this.mListener.onCommBoxSendData(ipAddress, code, (int)count, (int)sequence);
            }
        }
    }

    protected class CommBoxHistoryCallbackAdapter
    implements NativeCommBox.NativeCommBoxHistoryCallbackAdapter {
        private GetCommHistoryListener mListener = null;
        private ArrayList<HashMap<String, String>> mHistoryList = new ArrayList();

        public CommBoxHistoryCallbackAdapter(GetCommHistoryListener target) {
            this.mListener = target;
        }

        @Override
        public void onCommBoxHistory(long commBoxHandle, String ipAddress, int code, long sequence) {
            if (this.mListener != null) {
                if (code == 0) {
                    CommBox.this.outputBoxLogEvent("onGetCommHistory", ipAddress, code, this.mHistoryList, sequence);
                    this.mListener.onGetCommHistory(ipAddress, code, this.mHistoryList, (int)sequence);
                } else {
                    CommBox.this.outputBoxLogEvent("onGetCommHistory", ipAddress, code, null, sequence);
                    this.mListener.onGetCommHistory(ipAddress, code, null, (int)sequence);
                }
            }
        }

        @Override
        public void addHistory(String senderId, String receiverId, String message) {
            HashMap<String, String> history = new HashMap<String, String>();
            history.put("senderId", senderId);
            history.put("receiverId", receiverId);
            history.put("message", message);
            this.mHistoryList.add(history);
        }
    }
}

