package com.gingersoft.gsa.cloud.table.mvp.action.order;

import android.text.TextUtils;

import com.gingersoft.gsa.cloud.common.core.restaurant.RestaurantInfoManager;
import com.gingersoft.gsa.cloud.common.patterns.Strategy;
import com.gingersoft.gsa.cloud.common.utils.AppDevices;
import com.gingersoft.gsa.cloud.order.order.DoshokuOrder;
import com.gingersoft.gsa.cloud.pay.PayAction;
import com.gingersoft.gsa.cloud.pay.PaymentControl;
import com.gingersoft.gsa.cloud.pay.RequestParms;
import com.gingersoft.gsa.cloud.pay.ResultCallback;
import com.gingersoft.gsa.cloud.pay.bean.PayMethod;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.bg.GetTxnIdRequest;
import com.gingersoft.gsa.cloud.pay.device.pos.hyweb.bean.request.pos.VoidRequest;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.response.OrderManagerResponse;
import com.jess.arms.base.BaseFragmentActivity;
import com.jess.arms.mvp.IView;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

import java.util.List;

/**
 * @作者: bin
 * @創建時間: 2021-01-15 15:19
 * @更新時間: 2021-01-15 15:19
 * @描述:取消订单
 */
public class CancelOrder implements Strategy<OrderManagerResponse> {

    private final String TAG = "CancelOrder";

    private BaseFragmentActivity mActivity;
    private IView mRootView;

    public CancelOrder(BaseFragmentActivity fragmentActivity, IView rootView) {
        this.mActivity = fragmentActivity;
        this.mRootView = rootView;
    }

    @Override
    public void action(OrderManagerResponse orderItem) {
        showCancelDialog(orderItem);
    }

    @Override
    public void destroy() {
        mActivity = null;
        mRootView = null;
    }

    private void showCancelDialog(OrderManagerResponse datasBean) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(mActivity);
        dialogBuilder.setTitle("溫馨提示");
        dialogBuilder.setTitleIcon(R.drawable.qmui_icon_dialog_doubt);
        dialogBuilder.setMessage("是否取消訂單?");
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            if (AppDevices.isPosPay()) {
                posOrderCancle(datasBean);
            } else {
                if (cancelListener != null) {
                    cancelListener.cancel(datasBean.getId());
                }
            }
        });
        dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

    private void posOrderCancle(OrderManagerResponse datasBean) {
        GetTxnIdRequest txnIdRequest = new GetTxnIdRequest();
        txnIdRequest.setOrderId(datasBean.getId());
        if (!TextUtils.isEmpty(datasBean.getTableNumber())) {
            txnIdRequest.setTableExtId(datasBean.getTableId());
        } else {
            txnIdRequest.setTableId(datasBean.getTableId());
        }
        txnIdRequest.setAmount(datasBean.getAmount());
        VoidRequest voidRequest = new VoidRequest();

        int payType = 1106;
        List<OrderManagerResponse.OrderPayBean> orderPays = datasBean.getOrderPays();
        for (int i = 0; i < orderPays.size(); i++) {
            final OrderManagerResponse.OrderPayBean orderPayBean = orderPays.get(i);
            if (AppDevices.isYedpay()) {
                payType = orderPayBean.getPayType();
            }
        }

        RequestParms build =  RequestParms.builder()
                .action(PayAction.REFUND)
                .orderId(DoshokuOrder.getInstance().getOrderId())
                .resturantId(RestaurantInfoManager.newInstance().getRestaurantId())
                .payType(payType)
                .refundReason("客戶退款")
                .resultCallback(new ResultCallback() {

                    @Override
                    public void onSuccess() {
                        if (cancelListener != null) {
                            cancelListener.refeshOrders();
                        }
                    }

                    @Override
                    public void onFailure(Throwable t) {

                    }

                    @Override
                    public void externalPayment() {
                        if (cancelListener != null) {
                            cancelListener.cancel(datasBean.getId());
                        }
                    }

                    @Override
                    public void hybridPayment(List<PayMethod> payMethods) {

                    }
                })
                .build();
        PaymentControl.newInstance().showPayFlowFragment(mActivity, build);

//        PosPay.builder()
//                .context(GsaCloudApplication.getAppContext())
//                .lifecycleView(mRootView)
//                .posRequest(voidRequest)
//                .bgRequest(txnIdRequest)
//                .callback(new PosCallbackListener<VoidRespose>() {
//
//            @Override
//            public void onPosSuccess(VoidRespose response) {
//                LoganManager.w_order(TAG, "onPosSuccess: " + response.toString());
//                if (cancelListener != null) {
//                    cancelListener.refeshOrders();
//                }
//            }
//
//            @Override
//            public void onPosException(VoidRespose response, Exception e) {
//                LoganManager.w_order(TAG, "onPosException： " + e.getMessage());
//                PosActionStatusExceptionFragment statusExceptionFragment = (PosActionStatusExceptionFragment) mActivity.findFragment(PosActionStatusExceptionFragment.class);
//                if (statusExceptionFragment == null) {
//                    PosActionStatusExceptionParam statusExceptionParam = new PosActionStatusExceptionParam();
//                    statusExceptionParam.setTxnId(datasBean.getPayTxnId());
//                    statusExceptionParam.setAmount(datasBean.getAmount());
//                    statusExceptionParam.setOrderId(datasBean.getId());
//                    statusExceptionParam.setOrderNo(datasBean.getOrderNo());
//                    statusExceptionParam.setPayMethodName("VISA測試");
//                    statusExceptionParam.setPosAction(PosAction.VOID);
//                    mActivity.loadRootFragment(R.id.rl_container, PosActionStatusExceptionFragment.newInstance(statusExceptionParam));
//                }else{
//                    mActivity.start(statusExceptionFragment);
//                }
//            }
//
//            @Override
//            public void onPosInvalid(String e) {
//                LoganManager.w_order(TAG, "onPosInvalid: " + e);
//            }
//
//            @Override
//            public void onUpdateStatusSuccess(VoidRespose response) {
//                LoganManager.w_order(TAG, "onUpdateStatusSuccess: " + response.toString());
//            }
//
//            @Override
//            public void onUpdateStatusError(Throwable e) {
//                LoganManager.w_order(TAG, "onUpdateStatusError： " + e.getMessage());
//                if (mActivity.findFragment(PosActionStatusExceptionFragment.class) == null) {
//                    PosActionStatusExceptionParam statusExceptionParam = new PosActionStatusExceptionParam();
//                    statusExceptionParam.setTxnId(datasBean.getPayTxnId());
//                    statusExceptionParam.setAmount(datasBean.getAmount());
//                    statusExceptionParam.setOrderId(datasBean.getId());
//                    statusExceptionParam.setOrderNo(datasBean.getOrderNo());
//                    statusExceptionParam.setPayMethodName("VISA測試");
//                    statusExceptionParam.setPosAction(PosAction.VOID);
//                    mActivity.loadRootFragment(R.id.rl_container, PosActionStatusExceptionFragment.newInstance(statusExceptionParam));
//                }
//            }
//        });
    }

    private OnCancelListener cancelListener;

    public void setCancelListener(OnCancelListener cancelListener) {
        this.cancelListener = cancelListener;
    }

    public interface OnCancelListener {
        void cancel(long orderId);

        void refeshOrders();
    }
}
