package com.gingersoft.gsa.cloud.table.mvp.ui.fragment.mealstand;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.viewpager2.widget.ViewPager2;

import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.di.component.DaggerFineComponent;
import com.gingersoft.gsa.cloud.table.mvp.contract.FineContract;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.SoldoutCtrFood;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.event.LoadFineEvent;
import com.gingersoft.gsa.cloud.table.mvp.presenter.mealstand.FinePresenter;
import com.gingersoft.gsa.cloud.ui.adapter.ViewPager2Adapter;
import com.gingersoft.gsa.cloud.ui.view.MyTableView;
import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import com.jess.arms.base.BaseFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;

import org.simple.eventbus.EventBus;

import java.util.ArrayList;
import java.util.List;

import butterknife.BindView;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/24/2021 18:33
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class FineFragment extends BaseFragment<FinePresenter> implements FineContract.View {

    @BindView(R2.id.tabLayout)
    MyTableView tabFine;
    @BindView(R2.id.viewPager2)
    ViewPager2 vPager2Fine;

    private String[] mFineTitles = {"口味", "信息"};

    private FineChildAllFragment modSasteFineItemFragment, modMsgFineItemFragment;

    private LoadFineEvent mLoadFineEvent;

    @Override
    public void setupFragmentComponent(@NonNull AppComponent appComponent) {
        DaggerFineComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public View initView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_fine, container, false);
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {

        initViewPager();
    }

    private void initViewPager() {
        List<Fragment> fragments = new ArrayList<>();
        modSasteFineItemFragment = FineChildAllFragment.newInstance();
        modMsgFineItemFragment = FineChildAllFragment.newInstance();
        fragments.add(modSasteFineItemFragment);
        fragments.add(modMsgFineItemFragment);
        //实例化适配器
        ViewPager2Adapter viewPager2Adapter = new ViewPager2Adapter(_mActivity, fragments);
        //设置Viewpager2的适配器
        vPager2Fine.setAdapter(viewPager2Adapter);
        //TabLayout綁定Viewpager2
        TabLayoutMediator tab = new TabLayoutMediator(tabFine, vPager2Fine, true, new TabLayoutMediator.TabConfigurationStrategy() {

            @Override
            public void onConfigureTab(@NonNull TabLayout.Tab tab, int position) {
                tab.setText(mFineTitles[position]);
            }
        });
        tab.attach();
        tabFine.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener() {
            @Override
            public void onTabSelected(TabLayout.Tab tab) {
                int position = tab.getPosition();
                if (mLoadFineEvent != null) {
                    mLoadFineEvent.setCurrFinePage(position);
                    EventBus.getDefault().post(mLoadFineEvent, FineChildAllFragment.LOAD_FINE_DATA_EVENT);
                }
            }

            @Override
            public void onTabUnselected(TabLayout.Tab tab) {

            }

            @Override
            public void onTabReselected(TabLayout.Tab tab) {

            }
        });
    }

    public void updateFineData(LoadFineEvent fineEvent) {
        this.mLoadFineEvent = fineEvent;
    }

    public void setCurrentItem(int currFinePage) {
        vPager2Fine.setCurrentItem(currFinePage);
    }

    @Override
    public void setData(@Nullable Object data) {

    }

    @Override
    public void showLoading(String message) {
        if (message != null)
            LoadingDialog.showDialogForLoading(_mActivity, message, true);
        else
            LoadingDialog.showDialogForLoading(_mActivity);
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        checkNotNull(message);
        ArmsUtils.makeText(_mActivity, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        _mActivity.onBackPressedSupport();
    }


}
