package com.gingersoft.gsa.cloud.database.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.PrintModelBean;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "PRINT_MODEL_BEAN".
*/
public class PrintModelBeanDao extends AbstractDao<PrintModelBean, Long> {

    public static final String TABLENAME = "PRINT_MODEL_BEAN";

    /**
     * Properties of entity PrintModelBean.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Dbid = new Property(0, Long.class, "dbid", true, "_id");
        public final static Property Id = new Property(1, int.class, "id", false, "ID");
        public final static Property PaperSpecification = new Property(2, String.class, "paperSpecification", false, "PAPER_SPECIFICATION");
        public final static Property PrinterName = new Property(3, String.class, "printerName", false, "PRINTER_NAME");
        public final static Property Model = new Property(4, String.class, "model", false, "MODEL");
    }


    public PrintModelBeanDao(DaoConfig config) {
        super(config);
    }
    
    public PrintModelBeanDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"PRINT_MODEL_BEAN\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: dbid
                "\"ID\" INTEGER NOT NULL ," + // 1: id
                "\"PAPER_SPECIFICATION\" TEXT," + // 2: paperSpecification
                "\"PRINTER_NAME\" TEXT," + // 3: printerName
                "\"MODEL\" TEXT);"); // 4: model
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"PRINT_MODEL_BEAN\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, PrintModelBean entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getId());
 
        String paperSpecification = entity.getPaperSpecification();
        if (paperSpecification != null) {
            stmt.bindString(3, paperSpecification);
        }
 
        String printerName = entity.getPrinterName();
        if (printerName != null) {
            stmt.bindString(4, printerName);
        }
 
        String model = entity.getModel();
        if (model != null) {
            stmt.bindString(5, model);
        }
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, PrintModelBean entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getId());
 
        String paperSpecification = entity.getPaperSpecification();
        if (paperSpecification != null) {
            stmt.bindString(3, paperSpecification);
        }
 
        String printerName = entity.getPrinterName();
        if (printerName != null) {
            stmt.bindString(4, printerName);
        }
 
        String model = entity.getModel();
        if (model != null) {
            stmt.bindString(5, model);
        }
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public PrintModelBean readEntity(Cursor cursor, int offset) {
        PrintModelBean entity = new PrintModelBean( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // dbid
            cursor.getInt(offset + 1), // id
            cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2), // paperSpecification
            cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3), // printerName
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4) // model
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, PrintModelBean entity, int offset) {
        entity.setDbid(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setId(cursor.getInt(offset + 1));
        entity.setPaperSpecification(cursor.isNull(offset + 2) ? null : cursor.getString(offset + 2));
        entity.setPrinterName(cursor.isNull(offset + 3) ? null : cursor.getString(offset + 3));
        entity.setModel(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(PrintModelBean entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(PrintModelBean entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(PrintModelBean entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
