package com.gingersoft.gsa.cloud.base.table.bean;

import android.os.Parcel;
import android.os.Parcelable;
import com.qmuiteam.qmui.widget.section.QMUISection;
import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-05-20
 * 修订历史：2020-05-20
 * 描述：餐檯管理 餐檯類
 */
@Data
public class TableManagerItem implements Parcelable, QMUISection.Model<TableManagerItem>{

    /**
     * id : 25839
     * tableName : ceshitai1*
     * restaurantId : 26
     * orderId : 21568
     * qrCode : d662883361ef0e815f12b7cf46763bba
     * seatCount : 99
     * createTime : Dec 28, 2019 3:37:41 PM
     * createBy : GSPOS
     * qrCodeImg : http://localhost/qrcode/tableQrcode-26-1663.jpg
     * posTableId : 1663
     * serviceCharge : 0
     * memberId : 0
     * status : 0
     * person : 2
     * useStatus: 0
     * sort : 0
     * regionId : 1
     */

    private long id;
    /**區域ID*/
    private int regionId;
    /**區域名稱*/
    private String regionName;
    private String tableName;
    private int restaurantId;
    private Long orderId;
    private String qrCode;
    /**默認就餐人數*/
    private int seatCount;
    /**最大就餐人數*/
    private int maxSeatCount;
    /**最小就餐人數*/
    private int minSeatCount;
    private String createTime;
    private String createBy;
    private String qrCodeImg;
    private int posTableId;
    private int serviceCharge;
    private int memberId;
    /**
     * 未開檯   0
     * 已開檯   1
     * 已送單   2
     * 已印单   3
     */
    private int status;
    /**
     * 用餐人數
     */
    private int person;
    /**
     * 使用狀態:
     *  未使用   0
     *  已使用   1
     */
    private int useStatus;
    /**
     * 排序
     */
    private int sort;
    /**
     0:堂食
     1:外賣
     2:自取
     */
    private int type = -1;

    public static  final  int TABLE_TYPE_CANTEEN = 0;
    public static  final  int TABLE_TYPE_TAKEAWAY = 1;
    public static  final  int TABLE_TYPE_SELF_FETCHING = 2;

    /**
     * 自定義字段
     */
    /**是否選中*/
    private boolean isChecked = false;

    /**
     * UI类型:
     *  餐台       0
     *  新增(+)   1
     */
    private int layoutType = 0;

    public TableManagerItem() {
    }

    public TableManagerItem(TableManagerItem dataBean) {
        this.id = dataBean.id;
        this.regionId = dataBean.regionId;
        this.regionName = dataBean.regionName;
        this.tableName = dataBean.tableName;
        this.orderId = dataBean.orderId;
        this.restaurantId = dataBean.restaurantId;
        this.qrCode = dataBean.qrCode;
        this.seatCount = dataBean.seatCount;
        this.maxSeatCount = dataBean.maxSeatCount;
        this.minSeatCount = dataBean.minSeatCount;
        this.createTime = dataBean.createTime;
        this.createBy = dataBean.createBy;
        this.qrCodeImg = dataBean.qrCodeImg;
        this.posTableId = dataBean.posTableId;
        this.serviceCharge = dataBean.serviceCharge;
        this.memberId = dataBean.memberId;
        this.status = dataBean.status;
        this.person = dataBean.person;
        this.useStatus = dataBean.useStatus;
        this.sort = dataBean.sort;
        this.type = dataBean.type;
        this.isChecked = dataBean.isChecked;
    }

    @Override
    public TableManagerItem cloneForDiff() {
        return null;
    }

    @Override
    public boolean isSameItem(TableManagerItem other) {
        return false;
    }

    @Override
    public boolean isSameContent(TableManagerItem other) {
        return false;
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.id);
        dest.writeInt(this.regionId);
        dest.writeString(this.regionName);
        dest.writeString(this.tableName);
        dest.writeInt(this.restaurantId);
        dest.writeValue(this.orderId);
        dest.writeString(this.qrCode);
        dest.writeInt(this.seatCount);
        dest.writeInt(this.maxSeatCount);
        dest.writeInt(this.minSeatCount);
        dest.writeString(this.createTime);
        dest.writeString(this.createBy);
        dest.writeString(this.qrCodeImg);
        dest.writeInt(this.posTableId);
        dest.writeInt(this.serviceCharge);
        dest.writeInt(this.memberId);
        dest.writeInt(this.status);
        dest.writeInt(this.person);
        dest.writeInt(this.useStatus);
        dest.writeInt(this.sort);
        dest.writeInt(this.type);
        dest.writeByte(this.isChecked ? (byte) 1 : (byte) 0);
        dest.writeInt(this.layoutType);
    }

    protected TableManagerItem(Parcel in) {
        this.id = in.readLong();
        this.regionId = in.readInt();
        this.regionName = in.readString();
        this.tableName = in.readString();
        this.restaurantId = in.readInt();
        this.orderId = (Long) in.readValue(Long.class.getClassLoader());
        this.qrCode = in.readString();
        this.seatCount = in.readInt();
        this.maxSeatCount = in.readInt();
        this.minSeatCount = in.readInt();
        this.createTime = in.readString();
        this.createBy = in.readString();
        this.qrCodeImg = in.readString();
        this.posTableId = in.readInt();
        this.serviceCharge = in.readInt();
        this.memberId = in.readInt();
        this.status = in.readInt();
        this.person = in.readInt();
        this.useStatus = in.readInt();
        this.sort = in.readInt();
        this.type = in.readInt();
        this.isChecked = in.readByte() != 0;
        this.layoutType = in.readInt();
    }

    public static final Creator<TableManagerItem> CREATOR = new Creator<TableManagerItem>() {
        @Override
        public TableManagerItem createFromParcel(Parcel source) {
            return new TableManagerItem(source);
        }

        @Override
        public TableManagerItem[] newArray(int size) {
            return new TableManagerItem[size];
        }
    };
}
