package com.gingersoft.gsa.cloud.table.mvp.ui.adapter;

import android.app.Activity;
import android.graphics.Paint;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import com.gingersoft.gsa.cloud.base.order.billItem.BillOrderMoney;
import com.gingersoft.gsa.cloud.base.order.billItem.BillItem;
import com.gingersoft.gsa.cloud.table.R;
import com.gingersoft.gsa.cloud.table.R2;
import com.gingersoft.gsa.cloud.table.mvp.ui.activity.OrderContentActivity;
import com.jess.arms.base.BaseHolder;
import com.jess.arms.base.DefaultAdapter;

import java.util.List;

import butterknife.BindView;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2018/6/27
 * 修订历史：2018/6/27
 * 描述：
 */

public class BillItemAdapter extends DefaultAdapter<BillItem> {

    private Activity mContext;
    private String cashStr;

    /**
     * 是否免服務費(0:否 1:是)
     */
    private boolean isUseFreeServicePayMethod = false;
    private int BillTotalFontSize;

    public BillItemAdapter(Activity context, List<BillItem> infos, String cashStr) {
        super(infos);
        this.mContext = context;
        this.cashStr = cashStr;
//        this.BillTotalFontSize = GSAApplication.androidSetting.getBillTotalFontSize();
        this.BillTotalFontSize = 18;
    }

    public void setFreeServiceStauts(boolean isUseFreeServicePayMethod) {
        this.isUseFreeServicePayMethod = isUseFreeServicePayMethod;
    }

    public boolean getFreeServiceStauts() {
        return isUseFreeServicePayMethod;
    }

    @Override
    public int getItemCount() {
        return mInfos.size();
    }

    @Override
    public BaseHolder<BillItem> getHolder(View v, int viewType) {
        return new OrderMoneyItemHolder(v);
    }

    @Override
    public int getLayoutId(int viewType) {
        return R.layout.table_item_order_money;
    }

    class OrderMoneyItemHolder extends BaseHolder<BillItem> {

        @BindView(R2.id.ll_container)
        LinearLayout ll_container;
        @BindView(R2.id.tv_title)
        TextView tv_title;
        @BindView(R2.id.tv_money)
        TextView tv_money;

        @BindView(R2.id.iv_delete)
        ImageView iv_delete;

        public OrderMoneyItemHolder(View itemView) {
            super(itemView);
        }

        @Override
        public void setData(BillItem datasBean, int position) {

            tv_title.setText(datasBean.getName());

            if (datasBean.getMoney() < 0) {
                tv_money.setText("-" + cashStr + Math.abs(datasBean.getMoney()));
            } else {
                tv_money.setText(cashStr + datasBean.getMoney());
            }

            if (datasBean.getType() == BillOrderMoney.SERVERCHARGE_TYPE) {
                if (isUseFreeServicePayMethod) {
                    // 中划线
                    tv_title.getPaint().setFlags(Paint.STRIKE_THRU_TEXT_FLAG | Paint.ANTI_ALIAS_FLAG);
                    tv_money.getPaint().setFlags(Paint.STRIKE_THRU_TEXT_FLAG | Paint.ANTI_ALIAS_FLAG);
                } else {
                    // 取消设置的的划线
                    tv_title.getPaint().setFlags(0);
                    tv_money.getPaint().setFlags(0);
                }
            }

            tv_title.setTextSize(BillTotalFontSize);
            tv_money.setTextSize(BillTotalFontSize);

            tv_title.setTextColor(datasBean.getTextColor());
            tv_money.setTextColor(datasBean.getTextColor());

            if (mContext instanceof OrderContentActivity &&
                    (datasBean.getType() == BillOrderMoney.NOMAL_DISCOUNT_TYPE || datasBean.getType() == BillOrderMoney.COUPON_DISCOUNT_TYPE) &&
                    datasBean.getType() != BillOrderMoney.MEMBER_DISCOUNT_TYPE &&
                    datasBean.getStatus() == 0) {
                iv_delete.setVisibility(View.VISIBLE);
                iv_delete.setOnClickListener(v -> {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemDeleteClick(datasBean, position);
                    }
                });
            } else {
                iv_delete.setVisibility(View.INVISIBLE);
            }
            ll_container.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (mOnItemClickListener != null) {
                        mOnItemClickListener.onItemClick(datasBean, position);
                    }
                }
            });
//            ll_container.setBackgroundColor(datasBean.getBgColor());
        }
    }

    private OnItemClickListener mOnItemClickListener;

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        mOnItemClickListener = onItemClickListener;
    }

    public interface OnItemClickListener {

        void onItemClick(BillItem datasBean, int position);

        void onItemDeleteClick(BillItem datasBean, int position);
    }
}
