package com.gingersoft.gsa.cloud.base.order.bean.response;

import android.os.Parcel;
import android.os.Parcelable;

import lombok.Data;

/**
 * @author : bin
 * @create date: 2020-11-11
 * @update date: 2020-11-11
 * @description:
 */
@Data
public class OrderDiscountResponse implements Parcelable {

    /**
     * 餐廳折扣ID
     */
    private Long discountId;
    /**折扣金額*/
    private double discountAmount;
    /**折扣比例*/
    private int discountValue;
    /**
     * 0#餐廳折扣
     * 1#會員折扣
     * 2#优惠券折扣
     */
    private int type;
    /**
     * 餐廳折扣類型 0：金額，1：折扣，2：自定義金額，3：自由金額，數字盤，4：免服務費
     */
    private byte discountType;
    /**折扣名称1*/
    private String remark;
    /**折扣名称2*/
    private String remark2;
    /**折扣名称3*/
    private String remark3;

    /**
     * 优惠券折扣相关
     */
    // 消費滿
    private Double spend;
    /**
     * 是否累計滿減：0否，1是
     */
    private Byte accumulate;


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeValue(this.discountId);
        dest.writeDouble(this.discountAmount);
        dest.writeInt(this.discountValue);
        dest.writeInt(this.type);
        dest.writeByte(this.discountType);
        dest.writeString(this.remark);
        dest.writeString(this.remark2);
        dest.writeString(this.remark3);
        dest.writeValue(this.spend);
        dest.writeValue(this.accumulate);
    }

    protected OrderDiscountResponse(Parcel in) {
        this.discountId = (Long) in.readValue(Long.class.getClassLoader());
        this.discountAmount = in.readDouble();
        this.discountValue = in.readInt();
        this.type = in.readInt();
        this.discountType = in.readByte();
        this.remark = in.readString();
        this.remark2 = in.readString();
        this.remark3 = in.readString();
        this.spend = (Double) in.readValue(Double.class.getClassLoader());
        this.accumulate = (Byte) in.readValue(Byte.class.getClassLoader());
    }

    public static final Creator<OrderDiscountResponse> CREATOR = new Creator<OrderDiscountResponse>() {
        @Override
        public OrderDiscountResponse createFromParcel(Parcel source) {
            return new OrderDiscountResponse(source);
        }

        @Override
        public OrderDiscountResponse[] newArray(int size) {
            return new OrderDiscountResponse[size];
        }
    };
}
