package com.gingersoft.gsa.cloud.aspectj;

import android.app.Dialog;
import android.view.View;

import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.base.widget.DialogUtils;
import com.gingersoft.gsa.cloud.constans.PrintConstans;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

/**
 * Created by Wyh on 2020/3/2.
 * 組件化使用Aspect有問題。
 */
@Aspect
public class SwitchPrintAspect {

    /**
     * 定义切点，标记切点为所有被@SwitchPrintMethod注解的方法
     */
    @Pointcut("execution(@com.gingersoft.gsa.cloud.aspectj.SwitchPrintMethod * *(..))")
    public void methodAnnotated() {
    }

    /**
     * 定义一个切面方法，包裹切点方法
     */
    @Around("methodAnnotated()")
    public void aroundJoinPoint(ProceedingJoinPoint joinPoint) {
        // 取出方法的参数
        View view = null;
        for (Object arg : joinPoint.getArgs()) {
            if (arg instanceof View) {
                view = (View) arg;
                break;
            }
        }
        if (view == null || view.getContext() == null) {
            return;
        }
        // 顯示切換打印方式的彈窗
        new DialogUtils(view.getContext(), R.layout.print_select_print_method) {
            @Override
            public void initLayout(ViewHepler hepler, Dialog dialog) {
                hepler.setViewClick(R.id.local_print, v -> {
                    SPUtils.put(dialog.getContext(), PrintConstans.DEFAULT_PRINT_METHOD, PrintConstans.LOCAL_PRINT);
                    dialog.dismiss();
                });
                hepler.setViewClick(R.id.internet_print, v -> {
                    SPUtils.put(dialog.getContext(), PrintConstans.DEFAULT_PRINT_METHOD, PrintConstans.IP_PRINT);
                    dialog.dismiss();
                });
            }
        }.show();
    }
}
