package com.gingersoft.gsa.cloud.greendao;

import android.database.Cursor;
import android.database.sqlite.SQLiteStatement;

import org.greenrobot.greendao.AbstractDao;
import org.greenrobot.greendao.Property;
import org.greenrobot.greendao.internal.DaoConfig;
import org.greenrobot.greendao.database.Database;
import org.greenrobot.greendao.database.DatabaseStatement;

import com.gingersoft.gsa.cloud.database.bean.Modifier;

// THIS CODE IS GENERATED BY greenDAO, DO NOT EDIT.
/** 
 * DAO for table "MODIFIER".
*/
public class ModifierDao extends AbstractDao<Modifier, Long> {

    public static final String TABLENAME = "MODIFIER";

    /**
     * Properties of entity Modifier.<br/>
     * Can be used for QueryBuilder and for referencing column names.
     */
    public static class Properties {
        public final static Property Dbid = new Property(0, Long.class, "dbid", true, "_id");
        public final static Property Mid = new Property(1, long.class, "mid", false, "MID");
        public final static Property TopId = new Property(2, long.class, "topId", false, "TOP_ID");
        public final static Property RestaurantId = new Property(3, long.class, "restaurantId", false, "RESTAURANT_ID");
        public final static Property ModifierName = new Property(4, String.class, "modifierName", false, "MODIFIER_NAME");
        public final static Property SeqNo = new Property(5, long.class, "seqNo", false, "SEQ_NO");
        public final static Property MarketPrice = new Property(6, double.class, "marketPrice", false, "MARKET_PRICE");
        public final static Property Price = new Property(7, double.class, "price", false, "PRICE");
        public final static Property LunchboxPrice = new Property(8, double.class, "lunchboxPrice", false, "LUNCHBOX_PRICE");
        public final static Property ColorId = new Property(9, long.class, "colorId", false, "COLOR_ID");
        public final static Property ImageUrl = new Property(10, String.class, "imageUrl", false, "IMAGE_URL");
        public final static Property Invisible = new Property(11, long.class, "invisible", false, "INVISIBLE");
        public final static Property Cost = new Property(12, double.class, "cost", false, "COST");
        public final static Property StartDate = new Property(13, java.util.Date.class, "startDate", false, "START_DATE");
        public final static Property EndDate = new Property(14, java.util.Date.class, "endDate", false, "END_DATE");
        public final static Property Like = new Property(15, long.class, "like", false, "LIKE");
        public final static Property TotalSold = new Property(16, long.class, "totalSold", false, "TOTAL_SOLD");
        public final static Property MajorMainId = new Property(17, long.class, "majorMainId", false, "MAJOR_MAIN_ID");
        public final static Property DeptId = new Property(18, long.class, "deptId", false, "DEPT_ID");
        public final static Property CreateBy = new Property(19, String.class, "createBy", false, "CREATE_BY");
        public final static Property CreateTime = new Property(20, java.util.Date.class, "createTime", false, "CREATE_TIME");
        public final static Property UpdateBy = new Property(21, String.class, "updateBy", false, "UPDATE_BY");
        public final static Property UpdateTime = new Property(22, java.util.Date.class, "updateTime", false, "UPDATE_TIME");
        public final static Property PosFid = new Property(23, String.class, "posFid", false, "POS_FID");
        public final static Property PId = new Property(24, String.class, "pId", false, "P_ID");
        public final static Property AutoMod = new Property(25, long.class, "autoMod", false, "AUTO_MOD");
        public final static Property BlueEdit = new Property(26, long.class, "blueEdit", false, "BLUE_EDIT");
        public final static Property AutoMerge = new Property(27, long.class, "autoMerge", false, "AUTO_MERGE");
        public final static Property CustomMsg = new Property(28, long.class, "customMsg", false, "CUSTOM_MSG");
        public final static Property IsParent = new Property(29, long.class, "isParent", false, "IS_PARENT");
        public final static Property ModifierName1 = new Property(30, String.class, "modifierName1", false, "MODIFIER_NAME1");
        public final static Property ModifierName2 = new Property(31, String.class, "modifierName2", false, "MODIFIER_NAME2");
        public final static Property Multiple = new Property(32, double.class, "multiple", false, "MULTIPLE");
        public final static Property PrintSet = new Property(33, String.class, "printSet", false, "PRINT_SET");
        public final static Property KtSetting = new Property(34, String.class, "ktSetting", false, "KT_SETTING");
        public final static Property ModComm = new Property(35, long.class, "modComm", false, "MOD_COMM");
        public final static Property ModTaste = new Property(36, long.class, "modTaste", false, "MOD_TASTE");
        public final static Property ModMsg = new Property(37, long.class, "modMsg", false, "MOD_MSG");
        public final static Property KtFireCourse = new Property(38, long.class, "ktFireCourse", false, "KT_FIRE_COURSE");
        public final static Property AbleDisCount = new Property(39, long.class, "ableDisCount", false, "ABLE_DIS_COUNT");
        public final static Property PrintToBill = new Property(40, long.class, "printToBill", false, "PRINT_TO_BILL");
        public final static Property KtPrintMainItem = new Property(41, long.class, "ktPrintMainItem", false, "KT_PRINT_MAIN_ITEM");
        public final static Property KtShowPrice = new Property(42, long.class, "ktShowPrice", false, "KT_SHOW_PRICE");
        public final static Property KtFont = new Property(43, long.class, "ktFont", false, "KT_FONT");
        public final static Property Conditions = new Property(44, long.class, "conditions", false, "CONDITIONS");
        public final static Property IsRt = new Property(45, long.class, "isRt", false, "IS_RT");
        public final static Property Visible = new Property(46, byte.class, "visible", false, "VISIBLE");
        public final static Property Deletes = new Property(47, long.class, "deletes", false, "DELETES");
        public final static Property IsStatistic = new Property(48, long.class, "isStatistic", false, "IS_STATISTIC");
    }


    public ModifierDao(DaoConfig config) {
        super(config);
    }
    
    public ModifierDao(DaoConfig config, DaoSession daoSession) {
        super(config, daoSession);
    }

    /** Creates the underlying database table. */
    public static void createTable(Database db, boolean ifNotExists) {
        String constraint = ifNotExists? "IF NOT EXISTS ": "";
        db.execSQL("CREATE TABLE " + constraint + "\"MODIFIER\" (" + //
                "\"_id\" INTEGER PRIMARY KEY AUTOINCREMENT ," + // 0: dbid
                "\"MID\" INTEGER NOT NULL ," + // 1: mid
                "\"TOP_ID\" INTEGER NOT NULL ," + // 2: topId
                "\"RESTAURANT_ID\" INTEGER NOT NULL ," + // 3: restaurantId
                "\"MODIFIER_NAME\" TEXT," + // 4: modifierName
                "\"SEQ_NO\" INTEGER NOT NULL ," + // 5: seqNo
                "\"MARKET_PRICE\" REAL NOT NULL ," + // 6: marketPrice
                "\"PRICE\" REAL NOT NULL ," + // 7: price
                "\"LUNCHBOX_PRICE\" REAL NOT NULL ," + // 8: lunchboxPrice
                "\"COLOR_ID\" INTEGER NOT NULL ," + // 9: colorId
                "\"IMAGE_URL\" TEXT," + // 10: imageUrl
                "\"INVISIBLE\" INTEGER NOT NULL ," + // 11: invisible
                "\"COST\" REAL NOT NULL ," + // 12: cost
                "\"START_DATE\" INTEGER," + // 13: startDate
                "\"END_DATE\" INTEGER," + // 14: endDate
                "\"LIKE\" INTEGER NOT NULL ," + // 15: like
                "\"TOTAL_SOLD\" INTEGER NOT NULL ," + // 16: totalSold
                "\"MAJOR_MAIN_ID\" INTEGER NOT NULL ," + // 17: majorMainId
                "\"DEPT_ID\" INTEGER NOT NULL ," + // 18: deptId
                "\"CREATE_BY\" TEXT," + // 19: createBy
                "\"CREATE_TIME\" INTEGER," + // 20: createTime
                "\"UPDATE_BY\" TEXT," + // 21: updateBy
                "\"UPDATE_TIME\" INTEGER," + // 22: updateTime
                "\"POS_FID\" TEXT," + // 23: posFid
                "\"P_ID\" TEXT," + // 24: pId
                "\"AUTO_MOD\" INTEGER NOT NULL ," + // 25: autoMod
                "\"BLUE_EDIT\" INTEGER NOT NULL ," + // 26: blueEdit
                "\"AUTO_MERGE\" INTEGER NOT NULL ," + // 27: autoMerge
                "\"CUSTOM_MSG\" INTEGER NOT NULL ," + // 28: customMsg
                "\"IS_PARENT\" INTEGER NOT NULL ," + // 29: isParent
                "\"MODIFIER_NAME1\" TEXT," + // 30: modifierName1
                "\"MODIFIER_NAME2\" TEXT," + // 31: modifierName2
                "\"MULTIPLE\" REAL NOT NULL ," + // 32: multiple
                "\"PRINT_SET\" TEXT," + // 33: printSet
                "\"KT_SETTING\" TEXT," + // 34: ktSetting
                "\"MOD_COMM\" INTEGER NOT NULL ," + // 35: modComm
                "\"MOD_TASTE\" INTEGER NOT NULL ," + // 36: modTaste
                "\"MOD_MSG\" INTEGER NOT NULL ," + // 37: modMsg
                "\"KT_FIRE_COURSE\" INTEGER NOT NULL ," + // 38: ktFireCourse
                "\"ABLE_DIS_COUNT\" INTEGER NOT NULL ," + // 39: ableDisCount
                "\"PRINT_TO_BILL\" INTEGER NOT NULL ," + // 40: printToBill
                "\"KT_PRINT_MAIN_ITEM\" INTEGER NOT NULL ," + // 41: ktPrintMainItem
                "\"KT_SHOW_PRICE\" INTEGER NOT NULL ," + // 42: ktShowPrice
                "\"KT_FONT\" INTEGER NOT NULL ," + // 43: ktFont
                "\"CONDITIONS\" INTEGER NOT NULL ," + // 44: conditions
                "\"IS_RT\" INTEGER NOT NULL ," + // 45: isRt
                "\"VISIBLE\" INTEGER NOT NULL ," + // 46: visible
                "\"DELETES\" INTEGER NOT NULL ," + // 47: deletes
                "\"IS_STATISTIC\" INTEGER NOT NULL );"); // 48: isStatistic
    }

    /** Drops the underlying database table. */
    public static void dropTable(Database db, boolean ifExists) {
        String sql = "DROP TABLE " + (ifExists ? "IF EXISTS " : "") + "\"MODIFIER\"";
        db.execSQL(sql);
    }

    @Override
    protected final void bindValues(DatabaseStatement stmt, Modifier entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getMid());
        stmt.bindLong(3, entity.getTopId());
        stmt.bindLong(4, entity.getRestaurantId());
 
        String modifierName = entity.getModifierName();
        if (modifierName != null) {
            stmt.bindString(5, modifierName);
        }
        stmt.bindLong(6, entity.getSeqNo());
        stmt.bindDouble(7, entity.getMarketPrice());
        stmt.bindDouble(8, entity.getPrice());
        stmt.bindDouble(9, entity.getLunchboxPrice());
        stmt.bindLong(10, entity.getColorId());
 
        String imageUrl = entity.getImageUrl();
        if (imageUrl != null) {
            stmt.bindString(11, imageUrl);
        }
        stmt.bindLong(12, entity.getInvisible());
        stmt.bindDouble(13, entity.getCost());
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(14, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(15, endDate.getTime());
        }
        stmt.bindLong(16, entity.getLike());
        stmt.bindLong(17, entity.getTotalSold());
        stmt.bindLong(18, entity.getMajorMainId());
        stmt.bindLong(19, entity.getDeptId());
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(20, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(21, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(22, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(23, updateTime.getTime());
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(24, posFid);
        }
 
        String pId = entity.getPId();
        if (pId != null) {
            stmt.bindString(25, pId);
        }
        stmt.bindLong(26, entity.getAutoMod());
        stmt.bindLong(27, entity.getBlueEdit());
        stmt.bindLong(28, entity.getAutoMerge());
        stmt.bindLong(29, entity.getCustomMsg());
        stmt.bindLong(30, entity.getIsParent());
 
        String modifierName1 = entity.getModifierName1();
        if (modifierName1 != null) {
            stmt.bindString(31, modifierName1);
        }
 
        String modifierName2 = entity.getModifierName2();
        if (modifierName2 != null) {
            stmt.bindString(32, modifierName2);
        }
        stmt.bindDouble(33, entity.getMultiple());
 
        String printSet = entity.getPrintSet();
        if (printSet != null) {
            stmt.bindString(34, printSet);
        }
 
        String ktSetting = entity.getKtSetting();
        if (ktSetting != null) {
            stmt.bindString(35, ktSetting);
        }
        stmt.bindLong(36, entity.getModComm());
        stmt.bindLong(37, entity.getModTaste());
        stmt.bindLong(38, entity.getModMsg());
        stmt.bindLong(39, entity.getKtFireCourse());
        stmt.bindLong(40, entity.getAbleDisCount());
        stmt.bindLong(41, entity.getPrintToBill());
        stmt.bindLong(42, entity.getKtPrintMainItem());
        stmt.bindLong(43, entity.getKtShowPrice());
        stmt.bindLong(44, entity.getKtFont());
        stmt.bindLong(45, entity.getConditions());
        stmt.bindLong(46, entity.getIsRt());
        stmt.bindLong(47, entity.getVisible());
        stmt.bindLong(48, entity.getDeletes());
        stmt.bindLong(49, entity.getIsStatistic());
    }

    @Override
    protected final void bindValues(SQLiteStatement stmt, Modifier entity) {
        stmt.clearBindings();
 
        Long dbid = entity.getDbid();
        if (dbid != null) {
            stmt.bindLong(1, dbid);
        }
        stmt.bindLong(2, entity.getMid());
        stmt.bindLong(3, entity.getTopId());
        stmt.bindLong(4, entity.getRestaurantId());
 
        String modifierName = entity.getModifierName();
        if (modifierName != null) {
            stmt.bindString(5, modifierName);
        }
        stmt.bindLong(6, entity.getSeqNo());
        stmt.bindDouble(7, entity.getMarketPrice());
        stmt.bindDouble(8, entity.getPrice());
        stmt.bindDouble(9, entity.getLunchboxPrice());
        stmt.bindLong(10, entity.getColorId());
 
        String imageUrl = entity.getImageUrl();
        if (imageUrl != null) {
            stmt.bindString(11, imageUrl);
        }
        stmt.bindLong(12, entity.getInvisible());
        stmt.bindDouble(13, entity.getCost());
 
        java.util.Date startDate = entity.getStartDate();
        if (startDate != null) {
            stmt.bindLong(14, startDate.getTime());
        }
 
        java.util.Date endDate = entity.getEndDate();
        if (endDate != null) {
            stmt.bindLong(15, endDate.getTime());
        }
        stmt.bindLong(16, entity.getLike());
        stmt.bindLong(17, entity.getTotalSold());
        stmt.bindLong(18, entity.getMajorMainId());
        stmt.bindLong(19, entity.getDeptId());
 
        String createBy = entity.getCreateBy();
        if (createBy != null) {
            stmt.bindString(20, createBy);
        }
 
        java.util.Date createTime = entity.getCreateTime();
        if (createTime != null) {
            stmt.bindLong(21, createTime.getTime());
        }
 
        String updateBy = entity.getUpdateBy();
        if (updateBy != null) {
            stmt.bindString(22, updateBy);
        }
 
        java.util.Date updateTime = entity.getUpdateTime();
        if (updateTime != null) {
            stmt.bindLong(23, updateTime.getTime());
        }
 
        String posFid = entity.getPosFid();
        if (posFid != null) {
            stmt.bindString(24, posFid);
        }
 
        String pId = entity.getPId();
        if (pId != null) {
            stmt.bindString(25, pId);
        }
        stmt.bindLong(26, entity.getAutoMod());
        stmt.bindLong(27, entity.getBlueEdit());
        stmt.bindLong(28, entity.getAutoMerge());
        stmt.bindLong(29, entity.getCustomMsg());
        stmt.bindLong(30, entity.getIsParent());
 
        String modifierName1 = entity.getModifierName1();
        if (modifierName1 != null) {
            stmt.bindString(31, modifierName1);
        }
 
        String modifierName2 = entity.getModifierName2();
        if (modifierName2 != null) {
            stmt.bindString(32, modifierName2);
        }
        stmt.bindDouble(33, entity.getMultiple());
 
        String printSet = entity.getPrintSet();
        if (printSet != null) {
            stmt.bindString(34, printSet);
        }
 
        String ktSetting = entity.getKtSetting();
        if (ktSetting != null) {
            stmt.bindString(35, ktSetting);
        }
        stmt.bindLong(36, entity.getModComm());
        stmt.bindLong(37, entity.getModTaste());
        stmt.bindLong(38, entity.getModMsg());
        stmt.bindLong(39, entity.getKtFireCourse());
        stmt.bindLong(40, entity.getAbleDisCount());
        stmt.bindLong(41, entity.getPrintToBill());
        stmt.bindLong(42, entity.getKtPrintMainItem());
        stmt.bindLong(43, entity.getKtShowPrice());
        stmt.bindLong(44, entity.getKtFont());
        stmt.bindLong(45, entity.getConditions());
        stmt.bindLong(46, entity.getIsRt());
        stmt.bindLong(47, entity.getVisible());
        stmt.bindLong(48, entity.getDeletes());
        stmt.bindLong(49, entity.getIsStatistic());
    }

    @Override
    public Long readKey(Cursor cursor, int offset) {
        return cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0);
    }    

    @Override
    public Modifier readEntity(Cursor cursor, int offset) {
        Modifier entity = new Modifier( //
            cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0), // dbid
            cursor.getLong(offset + 1), // mid
            cursor.getLong(offset + 2), // topId
            cursor.getLong(offset + 3), // restaurantId
            cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4), // modifierName
            cursor.getLong(offset + 5), // seqNo
            cursor.getDouble(offset + 6), // marketPrice
            cursor.getDouble(offset + 7), // price
            cursor.getDouble(offset + 8), // lunchboxPrice
            cursor.getLong(offset + 9), // colorId
            cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10), // imageUrl
            cursor.getLong(offset + 11), // invisible
            cursor.getDouble(offset + 12), // cost
            cursor.isNull(offset + 13) ? null : new java.util.Date(cursor.getLong(offset + 13)), // startDate
            cursor.isNull(offset + 14) ? null : new java.util.Date(cursor.getLong(offset + 14)), // endDate
            cursor.getLong(offset + 15), // like
            cursor.getLong(offset + 16), // totalSold
            cursor.getLong(offset + 17), // majorMainId
            cursor.getLong(offset + 18), // deptId
            cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19), // createBy
            cursor.isNull(offset + 20) ? null : new java.util.Date(cursor.getLong(offset + 20)), // createTime
            cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21), // updateBy
            cursor.isNull(offset + 22) ? null : new java.util.Date(cursor.getLong(offset + 22)), // updateTime
            cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23), // posFid
            cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24), // pId
            cursor.getLong(offset + 25), // autoMod
            cursor.getLong(offset + 26), // blueEdit
            cursor.getLong(offset + 27), // autoMerge
            cursor.getLong(offset + 28), // customMsg
            cursor.getLong(offset + 29), // isParent
            cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30), // modifierName1
            cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31), // modifierName2
            cursor.getDouble(offset + 32), // multiple
            cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33), // printSet
            cursor.isNull(offset + 34) ? null : cursor.getString(offset + 34), // ktSetting
            cursor.getLong(offset + 35), // modComm
            cursor.getLong(offset + 36), // modTaste
            cursor.getLong(offset + 37), // modMsg
            cursor.getLong(offset + 38), // ktFireCourse
            cursor.getLong(offset + 39), // ableDisCount
            cursor.getLong(offset + 40), // printToBill
            cursor.getLong(offset + 41), // ktPrintMainItem
            cursor.getLong(offset + 42), // ktShowPrice
            cursor.getLong(offset + 43), // ktFont
            cursor.getLong(offset + 44), // conditions
            cursor.getLong(offset + 45), // isRt
            (byte) cursor.getShort(offset + 46), // visible
            cursor.getLong(offset + 47), // deletes
            cursor.getLong(offset + 48) // isStatistic
        );
        return entity;
    }
     
    @Override
    public void readEntity(Cursor cursor, Modifier entity, int offset) {
        entity.setDbid(cursor.isNull(offset + 0) ? null : cursor.getLong(offset + 0));
        entity.setMid(cursor.getLong(offset + 1));
        entity.setTopId(cursor.getLong(offset + 2));
        entity.setRestaurantId(cursor.getLong(offset + 3));
        entity.setModifierName(cursor.isNull(offset + 4) ? null : cursor.getString(offset + 4));
        entity.setSeqNo(cursor.getLong(offset + 5));
        entity.setMarketPrice(cursor.getDouble(offset + 6));
        entity.setPrice(cursor.getDouble(offset + 7));
        entity.setLunchboxPrice(cursor.getDouble(offset + 8));
        entity.setColorId(cursor.getLong(offset + 9));
        entity.setImageUrl(cursor.isNull(offset + 10) ? null : cursor.getString(offset + 10));
        entity.setInvisible(cursor.getLong(offset + 11));
        entity.setCost(cursor.getDouble(offset + 12));
        entity.setStartDate(cursor.isNull(offset + 13) ? null : new java.util.Date(cursor.getLong(offset + 13)));
        entity.setEndDate(cursor.isNull(offset + 14) ? null : new java.util.Date(cursor.getLong(offset + 14)));
        entity.setLike(cursor.getLong(offset + 15));
        entity.setTotalSold(cursor.getLong(offset + 16));
        entity.setMajorMainId(cursor.getLong(offset + 17));
        entity.setDeptId(cursor.getLong(offset + 18));
        entity.setCreateBy(cursor.isNull(offset + 19) ? null : cursor.getString(offset + 19));
        entity.setCreateTime(cursor.isNull(offset + 20) ? null : new java.util.Date(cursor.getLong(offset + 20)));
        entity.setUpdateBy(cursor.isNull(offset + 21) ? null : cursor.getString(offset + 21));
        entity.setUpdateTime(cursor.isNull(offset + 22) ? null : new java.util.Date(cursor.getLong(offset + 22)));
        entity.setPosFid(cursor.isNull(offset + 23) ? null : cursor.getString(offset + 23));
        entity.setPId(cursor.isNull(offset + 24) ? null : cursor.getString(offset + 24));
        entity.setAutoMod(cursor.getLong(offset + 25));
        entity.setBlueEdit(cursor.getLong(offset + 26));
        entity.setAutoMerge(cursor.getLong(offset + 27));
        entity.setCustomMsg(cursor.getLong(offset + 28));
        entity.setIsParent(cursor.getLong(offset + 29));
        entity.setModifierName1(cursor.isNull(offset + 30) ? null : cursor.getString(offset + 30));
        entity.setModifierName2(cursor.isNull(offset + 31) ? null : cursor.getString(offset + 31));
        entity.setMultiple(cursor.getDouble(offset + 32));
        entity.setPrintSet(cursor.isNull(offset + 33) ? null : cursor.getString(offset + 33));
        entity.setKtSetting(cursor.isNull(offset + 34) ? null : cursor.getString(offset + 34));
        entity.setModComm(cursor.getLong(offset + 35));
        entity.setModTaste(cursor.getLong(offset + 36));
        entity.setModMsg(cursor.getLong(offset + 37));
        entity.setKtFireCourse(cursor.getLong(offset + 38));
        entity.setAbleDisCount(cursor.getLong(offset + 39));
        entity.setPrintToBill(cursor.getLong(offset + 40));
        entity.setKtPrintMainItem(cursor.getLong(offset + 41));
        entity.setKtShowPrice(cursor.getLong(offset + 42));
        entity.setKtFont(cursor.getLong(offset + 43));
        entity.setConditions(cursor.getLong(offset + 44));
        entity.setIsRt(cursor.getLong(offset + 45));
        entity.setVisible((byte) cursor.getShort(offset + 46));
        entity.setDeletes(cursor.getLong(offset + 47));
        entity.setIsStatistic(cursor.getLong(offset + 48));
     }
    
    @Override
    protected final Long updateKeyAfterInsert(Modifier entity, long rowId) {
        entity.setDbid(rowId);
        return rowId;
    }
    
    @Override
    public Long getKey(Modifier entity) {
        if(entity != null) {
            return entity.getDbid();
        } else {
            return null;
        }
    }

    @Override
    public boolean hasKey(Modifier entity) {
        return entity.getDbid() != null;
    }

    @Override
    protected final boolean isEntityUpdateable() {
        return true;
    }
    
}
