package com.gingersoft.gsa.delivery_pick_mode.mvp.ui.activity;

import android.content.Intent;
import android.os.Bundle;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.gsa.cloud.ui.widget.dialog.LoadingDialog;
import com.gingersoft.gsa.delivery_pick_mode.R;
import com.gingersoft.gsa.delivery_pick_mode.R2;
import com.gingersoft.gsa.delivery_pick_mode.di.component.DaggerAddressListComponent;
import com.gingersoft.gsa.delivery_pick_mode.mvp.contract.AddressListContract;
import com.gingersoft.gsa.delivery_pick_mode.mvp.model.MemberAddressInfoBean;
import com.gingersoft.gsa.delivery_pick_mode.mvp.presenter.AddressListPresenter;
import com.gingersoft.gsa.delivery_pick_mode.mvp.ui.adapter.AddressAdapter;
import com.jess.arms.base.BaseActivity;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.utils.ArmsUtils;
import com.qmuiteam.qmui.widget.QMUITopBar;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;

import static com.jess.arms.utils.Preconditions.checkNotNull;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 10/16/2020 15:53
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
public class AddressListActivity extends BaseActivity<AddressListPresenter> implements AddressListContract.View {

    @BindView(R2.id.rv_address_list)
    RecyclerView rvAddressList;


    public static final String RESULT_DATA_NAME = "addressDetail";
    public static final String RESULT_CODE = "resultCode";
    public static final String REQUEST_ADDRESS_LIST_NAME = "addressList";
    @BindView(R2.id.address_list_top_bar)
    QMUITopBar addressListTopBar;

    @Override
    public void setupActivityComponent(@NonNull AppComponent appComponent) {
        DaggerAddressListComponent //如找不到该类,请编译一下项目
                .builder()
                .appComponent(appComponent)
                .view(this)
                .build()
                .inject(this);
    }

    @Override
    public int initView(@Nullable Bundle savedInstanceState) {
        return R.layout.activity_address_list;
    }

    @Override
    public void initData(@Nullable Bundle savedInstanceState) {
        List<MemberAddressInfoBean.DataBean> dataBeanList = (List<MemberAddressInfoBean.DataBean>) getIntent().getSerializableExtra(REQUEST_ADDRESS_LIST_NAME);
        int resultCode = getIntent().getIntExtra(RESULT_CODE, 0);
        AddressAdapter addressAdapter = new AddressAdapter(dataBeanList);
        addressAdapter.setOnItemChildClickListener((adapter, view, position) -> {
            Intent intent = new Intent();
            intent.putExtra(RESULT_DATA_NAME, dataBeanList.get(position));
            setResult(resultCode, intent);
            finish();
        });
        rvAddressList.setAdapter(addressAdapter);
        rvAddressList.setLayoutManager(new LinearLayoutManager(mContext));
    }

    @Override
    public void initIntent() {

    }

    @Override
    public void initTopBar() {
        addressListTopBar.setTitle("地址列表");
        addressListTopBar.setBackgroundColor(ContextCompat.getColor(this, R.color.theme_color));
        addressListTopBar.addLeftImageButton(R.drawable.icon_return, R.id.iv_left_back).setOnClickListener(v -> killMyself());
    }

    @Override
    public void initLanguage() {

    }

    @Override
    public void initLayoutParams() {

    }

    @Override
    public void initLayoutVisible() {

    }

    @Override
    public void showLoading(String message) {
        if (message != null) {
            LoadingDialog.showDialogForLoading(this, message, true);
        } else {
            LoadingDialog.showDialogForLoading(this);
        }
    }

    @Override
    public void hideLoading() {
        LoadingDialog.cancelDialogForLoading();
    }

    @Override
    public void showMessage(@NonNull String message) {
        ArmsUtils.makeText(this, message);
    }

    @Override
    public void launchActivity(@NonNull Intent intent) {
        checkNotNull(intent);
        ArmsUtils.startActivity(intent);
    }

    @Override
    public void killMyself() {
        finish();
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        // TODO: add setContentView(...) invocation
        ButterKnife.bind(this);
    }
}
