package com.gingersoft.gsa.cloud.main.mvp.ui.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.gingersoft.gsa.cloud.base.utils.time.TimePickerUtils;
import com.gingersoft.gsa.cloud.base.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.main.R;
import com.gingersoft.gsa.cloud.ui.view.TriangleView;

import java.text.ParseException;
import java.util.Calendar;

public class StartEndTimePickerView extends FrameLayout implements View.OnClickListener {

    private TextView tvStartTime;
    private TriangleView startTriangleView;
    private TextView tvEndTime;
    private TriangleView endTriangleView;

    private onUpdateTimePicker onUpdateTimePicker;

    public StartEndTimePickerView(@NonNull Context context) {
        this(context, null, -1);
    }

    public StartEndTimePickerView(@NonNull Context context, onUpdateTimePicker onUpdateTimePicker) {
        this(context);
        this.onUpdateTimePicker = onUpdateTimePicker;
    }

    public StartEndTimePickerView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, -1);
    }

    public StartEndTimePickerView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        init(context);
    }

    public void setOnUpdateTimePicker(StartEndTimePickerView.onUpdateTimePicker onUpdateTimePicker) {
        this.onUpdateTimePicker = onUpdateTimePicker;
    }

    private void init(Context context) {
        View view = View.inflate(context, R.layout.layout_start_end_time_picker, null);
        tvStartTime = view.findViewById(R.id.tv_start_time);
        startTriangleView = view.findViewById(R.id.iv_start_time_triangle);
        tvEndTime = view.findViewById(R.id.tv_end_time);
        endTriangleView = view.findViewById(R.id.iv_end_time_triangle);

        tvStartTime.setText(TimeUtils.getOldDate(-7));
        tvEndTime.setText(TimeUtils.getOldDate(0));

        tvStartTime.setOnClickListener(this);
        startTriangleView.setOnClickListener(this);
        tvEndTime.setOnClickListener(this);
        endTriangleView.setOnClickListener(this);
        updateTime();
        this.addView(view);
    }

    @Override
    public void onClick(View v) {
        int viewId = v.getId();
        try {
            String time;
            Calendar startTime = Calendar.getInstance();
            startTime.set(Calendar.DAY_OF_YEAR, startTime.getActualMinimum(Calendar.DAY_OF_YEAR));//今年第一天

            Calendar endTime = Calendar.getInstance();

            if (viewId == R.id.tv_start_time || viewId == R.id.iv_start_time_triangle) {
                startTriangleView.toggle();
                time = tvStartTime.getText().toString();

                endTime.setTime(TimeUtils.DATE_FORMAT_DATE.parse(tvEndTime.getText().toString()));
            } else {
                endTriangleView.toggle();
                time = tvEndTime.getText().toString();
                startTime.setTime(TimeUtils.DATE_FORMAT_DATE.parse(tvStartTime.getText().toString()));
            }

            Calendar cal = Calendar.getInstance();
            try {
                //設置默認時間為當前的起止時間
                cal.setTime(TimeUtils.DATE_FORMAT_DATE.parse(time));
            } catch (ParseException e) {
                e.printStackTrace();
            }
            //打開時間選擇器
            TimePickerUtils.showReportTimePicker(v.getContext(), startTime, endTime, cal, (date, v1) ->
            {
                if (viewId == R.id.tv_start_time || viewId == R.id.iv_start_time_triangle) {
                    tvStartTime.setText(TimeUtils.DATE_FORMAT_DATE.format(date));
                } else {
                    tvEndTime.setText(TimeUtils.DATE_FORMAT_DATE.format(date));
                }
                updateTime();
            }).setOnDismissListener(o -> {
                if (startTriangleView.isOpen()) {
                    startTriangleView.toggle();
                } else if (endTriangleView.isOpen()) {
                    endTriangleView.toggle();
                }
            });
        } catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private void updateTime() {
        if (onUpdateTimePicker != null) {
            onUpdateTimePicker.onUpdateTime(tvStartTime.getText().toString(), tvEndTime.getText().toString());
        }
    }


    public interface onUpdateTimePicker {
        void onUpdateTime(String startTime, String endTime);
    }

    public String getStartTime(){
        if(tvStartTime != null){
            return tvStartTime.getText().toString();
        }
        return TimeUtils.getOldDate(-7);
    }

    public String getEndTime(){
        if(tvEndTime != null){
            return tvEndTime.getText().toString();
        }
        return TimeUtils.getOldDate(0);
    }

}
