package com.gingersoft.gsa.cloud.base.order.bean.discount;


import com.gingersoft.gsa.cloud.base.common.bean.MemberInfo;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-09-12
 * 修订历史：2020-09-12
 * 描述：扫码查询优惠券折扣返回实体
 */
@Data
public class CouponDiscountResult {

    /**
     * 會員優惠券信息
     */
    private CouponDiscountBean couponBean;
    /**
     * 會員信息
     */
    private MemberInfo memberInfo;

    /**會已在其他餐廳使用*/
    public static final String ERROR_CODE_0001 = "MEMBER.0001";
    /**掃描的會員優惠券與當前品牌不一致*/
    public static final String ERROR_CODE_0002 = "MEMBER.0002";
    /**掃了其他會員的優惠券碼*/
    public static final String ERROR_CODE_0003 = "MEMBER.0003";

    public CouponDiscountBean getCouponBean() {
        return couponBean;
    }

    public void setCouponBean(CouponDiscountBean couponBean) {
        this.couponBean = couponBean;
    }

    public MemberInfo getMemberInfo() {
        return memberInfo;
    }

    public void setMemberInfo(MemberInfo memberInfo) {
        this.memberInfo = memberInfo;
    }

    public static String getErrorCode0001() {
        return ERROR_CODE_0001;
    }

    public static String getErrorCode0002() {
        return ERROR_CODE_0002;
    }

    public static String getErrorCode0003() {
        return ERROR_CODE_0003;
    }
}
