package com.joe.print.mvp.print;

import android.graphics.Bitmap;

import com.gingersoft.gsa.cloud.print.PrintDataMaker;
import com.gingersoft.gsa.cloud.print.PrinterWriter;
import com.gingersoft.gsa.cloud.print.PrinterWriterExecutor;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by Wyh on 2020/1/9.
 * ip打印類
 */
public class IpPrintMaker implements PrintDataMaker {

    private int width; // 打印的圖片寬度,紙張寬度
    private List<Bitmap> bitmaps;

    public IpPrintMaker(int width, List<Bitmap> bitmaps) {
        this.width = width;
        this.bitmaps = bitmaps;
    }

    @Override
    public List<byte[]> getPrintData() {
        ArrayList<byte[]> data = new ArrayList<>();
        try {
            PrinterWriter printer;
            printer = new PrinterWriterExecutor(255, width);
            printer.setAlignCenter();
            data.add(printer.getDataAndReset());
            for (int i = 0; i < bitmaps.size(); i++) {
                ArrayList<byte[]> image1 = printer.getImageByte(bitmaps.get(i));//將bitmap縮放到打印機紙張大小再添加到集合中。
                data.addAll(image1);//draw2PxPoint2(bitmaps.get(i)
                printer.printLineFeed(3);
                printer.feedPaperCutPartial();
                data.add(printer.getDataAndReset());
            }
            data.add(printer.getDataAndClose());
            for (int i = 0; i < bitmaps.size(); i++){
                bitmaps.get(i).recycle();
            }
            return data;
        } catch (Exception e) {
            return new ArrayList<>();
        }
    }

    @Override
    public String getPrjIds() {
        return null;
    }
}
