package com.gingersoft.gsa.cloud.ui.adapter;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.R;
import com.gingersoft.gsa.cloud.base.common.bean.PayMethod;
import com.qmuiteam.qmui.alpha.QMUIAlphaTextView;

import java.util.List;

/**
 * Created by Wyh on 2020/1/17.
 */
public class BillMethodAdapter extends BaseQuickAdapter<PayMethod, BaseViewHolder> {

    public BillMethodAdapter(@Nullable List<PayMethod> data) {
        super(R.layout.item_bill_method, data);
    }

    @Override
    protected void convert(BaseViewHolder helper, PayMethod item) {
        QMUIAlphaTextView tv_bill_method_name = helper.getView(R.id.tv_bill_method_name);
        tv_bill_method_name.setText(item.getPayName());
        tv_bill_method_name.setTextSize(item.getPayModeSize());
        tv_bill_method_name.setTextColor(item.getPayModeTextColor());
    }

}
