package com.gingersoft.gsa.other_order_mode.ui.adapter

import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import androidx.databinding.DataBindingUtil
import com.chad.library.adapter.base.BaseQuickAdapter
import com.chad.library.adapter.base.BaseViewHolder
import com.gingersoft.gsa.other_order_mode.R
import com.gingersoft.gsa.other_order_mode.data.model.bean.DeliveryConfig
import com.gingersoft.gsa.other_order_mode.databinding.ItemDeliveryLayoutBinding

class DeliveryListAdapter(val context: Context, data: List<DeliveryConfig.Data.DeliveryInfo>) : BaseQuickAdapter<DeliveryConfig.Data.DeliveryInfo, DeliveryListAdapter.ViewHolder>(data) {

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        val view = LayoutInflater.from(parent.context).inflate(R.layout.item_delivery_layout, null)
        return ViewHolder(view)
    }

    override fun convert(helper: ViewHolder?, item: DeliveryConfig.Data.DeliveryInfo?) {
        helper?.let { helper ->
            helper.binding.apply {
                deliveryType = when (item!!.distributionType) {
                    "SHORT_RANGE" -> "短途送"
                    "STANDARD" -> "中途送"
                    "LONG_DISTANCE" -> "長途送"
                    else -> ""
                }
                item.let {
                    //                    deliveryType = it.distributionType
                    deliveryExpenses = "${it.distributionFeeMin}-${it.distributionFeeMax}"
                    deliveryFee = it.deliveryCost.toString()
                    deliveryMethod = if (it.type == 1) "物流配送" else "本店配送"
                    deliveryDifference = it.lackPrice.toString()
                }
            }
            helper.getView<ImageView>(R.id.iv_delete).setOnClickListener {
                onItemChildClickListener?.onItemChildClick(this, it, helper.adapterPosition)
            }
            helper.itemView.setOnClickListener {
                onItemChildClickListener?.onItemChildClick(this, it, helper.adapterPosition)
            }
        }
    }

    class ViewHolder(itemView: View) : BaseViewHolder(itemView) {
        var binding: ItemDeliveryLayoutBinding = DataBindingUtil.bind(itemView)!!
    }

}