package com.gingersoft.gsa.cloud.table.mvp.model.service;

import com.gingersoft.gsa.cloud.base.Api;
import com.gingersoft.gsa.cloud.base.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.base.common.bean.FoodBean;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.BaseRespose;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.FoodReason;
import com.gingersoft.gsa.cloud.table.mvp.model.bean.request.DeleteOrderRequest;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;
import me.jessyan.retrofiturlmanager.RetrofitUrlManager;
import okhttp3.FormBody;
import okhttp3.RequestBody;
import retrofit2.http.Body;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.Query;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-06
 * 修订历史：2020-01-06
 * 描述：
 */
public interface MealService {

    @Headers({"Domain-Name: soldoutctrl"})
    @POST("foodChecklist/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> getCurrentSoldoutFood(@Body RequestBody requestBody);

    @Headers({"Domain-Name: soldoutctrl"})
    @POST("foodChecklist/insert" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> insertSoldoutCtrl(@Body RequestBody requestBody);

    @Headers({"Domain-Name: soldoutctrl"})
    @POST("foodChecklist/updatePrg" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> restoreSoldoutCtrl(@Body RequestBody requestBody);

    @POST("food/updateInvisible" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> updateInvisible(@Body RequestBody requestBody);

//    @Headers({"Domain-Name: yc_location"})
    @POST("order/send" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> createOrder(@Body RequestBody requestBody);

//    @Headers({"Domain-Name: yc_location"})
    @POST("orderDetails/add" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> addFood(@Body RequestBody requestBody);

    @FormUrlEncoded
    @POST("order/get" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> loadOrder(@Field("orderId") long orderId);

//    @FormUrlEncoded
    @POST("orderDetails/delete" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> deleteFood(@Body RequestBody requestBody);

    @FormUrlEncoded
    @POST("order/calculation/price" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> calculationPrice(@Field("orderId") long orderId);

    @POST("restaurantTable/print" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> printOrder(@Body RequestBody requestBody);

    @GET("restaurantFoodReason/config/list" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<FoodReason> getRestaurantFoodReason(@Query("brandId") int brandId , @Query("restaurantId") int restaurantId, @Query("type") int type);

    @POST("restaurantTable/transfer" + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseRespose> transferFood(@Body RequestBody requestBody);

    @GET(Api.food_list + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<FoodBean> downFoodList(@Query("restaurantId") int restaurantId);

    @GET(Api.food_modifiere_relation + RetrofitUrlManager.IDENTIFICATION_PATH_SIZE + 2)
    Observable<BaseResult> downFoodModifier(@Query("restaurantId") int restaurantId);

}
