package com.gingersoft.gsa.cloud.database.bean;

import android.graphics.Color;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Generated;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.ToOne;
import org.greenrobot.greendao.annotation.Transient;

import java.util.Date;

import org.greenrobot.greendao.DaoException;

import com.gingersoft.gsa.cloud.database.greendao.DaoSession;
import com.gingersoft.gsa.cloud.database.greendao.ColorBeanDao;
import com.gingersoft.gsa.cloud.database.greendao.FoodDao;

import org.greenrobot.greendao.annotation.NotNull;

import lombok.Data;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-01-02
 * 修订历史：2020-01-02
 * 描述：
 */

@Data
@Entity
public class Food {

    /**
     * ID
     */
    @Property(nameInDb = "FID")
    @Id(autoincrement = true)
    private Long id;
    /**
     * 上級ID (如0=最高級)
     */
    private long parentId;
    /**
     * 商户ID
     */
    private long restaurantId;
    /**食品ID*/
//    private Long fid;
    /**
     * 是否組別
     */
    private byte isParent;
    /**
     * 排序
     */
    private long seqNo;
    /**
     * 名稱1
     */
    private String foodName;
    /**
     * 食品名称1
     */
    private String foodName1;
    /**
     * 食品名称2
     */
    private String foodName2;
    /**
     * 自定義食品編號
     */
    private String plu;
    /**
     * 自定義类型 #100=不可自定义 #101=自定义食品名称及金额 #102=自定义食品金额
     */
    private Integer customType;
    public static final int CUSTOM_TYPE_100 = 100;
    public static final int CUSTOM_TYPE_101 = 101;
    public static final int CUSTOM_TYPE_102 = 102;
    /**
     * 本地对应ID
     */
    private String posFid;
    /**
     * 描述
     */
    private String foodDesc;
    /**
     * 限制比例#0不做判断;（人数*N）
     */
    private long limitAmount;
    /**
     * 限制类型#1:表示每次送单限制 ;2:表示整单限制
     */
    private long limitType;
    /**
     * 餐种{@link com.gingersoft.gsa.cloud.common.constans.FoodSummaryConstans}
     */
    private String foodSummary;
    /**
     * 0=顯示, 1=隱藏, 2=暫停,3=只显示,不操作
     */
    private long invisible;
    /**
     * 自動跳出細項頁
     */
    private byte autoMod;
    /**
     * 金額
     */
    private double price;
    /**
     * 原價 (刪除線)
     */
    private double marketPrice;
    /**
     * 餐盒费
     */
    private double lunchboxPrice;
    /**
     * 食品小图片
     */
    private String imgUrlSmall;
    /**
     * 食品大图片
     */
    private String imageurl;
    /**
     * ricepon显示状态，当为0的时候，取Invisible的状态:0=顯示, 1=隱藏, 2=暫停
     */
    private long riceponInvisible;
    /**
     * 成本
     */
    private double cost;
    /**
     * 贊
     */
    private long like;
    /**
     * 已售
     */
    private long totalSold;
    /**
     * 是否显示已售
     */
    private long isSold;
    /**
     * 開始日期
     */
    private Date startDate;
    /**
     * 結束日期
     */
    private Date endDate;
    /**
     * 创建人
     */
    private String createBy;

    private Date createTime;
    /**
     * 更新人
     */
    private String updateBy;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 時段, 請關聯到m_period_info
     */
    private long periodId;
    /**
     * 是否参与折扣,是否自定义食品：
     * 可折扣 1
     * 可折扣、自定義食品名稱和金額 3
     * 可折扣、自定義金額 5
     * 可折扣、合併名稱及金額 7
     * 可折扣、合併名稱 9
     * <p>
     * 不可折扣 0
     * 不可折扣、自定義食品名稱和金額 2
     * 不可折扣、自定義金額 4
     * 不可折扣、合併名稱及金額 6
     * 不可折扣、合併名稱 8
     */
    private long ableDiscount;
    /**
     * 是否外卖#0:是;1:否
     */
    private long takeaway;
    /**
     * 餐頁面中藍色按鈕有沒有編輯按鈕  (筆的圖按) 0=不可編輯 1=可編輯
     */
    private long blueEdit;
    /**
     * 購物車中是否可編輯  (加入口味)  0=隱藏購物車中食品的編輯按鈕 1=顯示按鈕
     */
    private long cartEdit;
    /**
     * 相同項目自動合併 0=不自動合併 1=自動合併
     */
    private long autoMerge;
    /**
     * 打印設定, 用逗號分隔, *=切紙
     */
    private String printSeting;
    /**
     * 是否打印叫号小票
     */
    private long isPrintQueueCode;
    /**
     * 打印叫号小票对应队ID
     */
    private long queueHeadId;
    /**
     * 是否需要經理批準
     */
    private long approve;
    /**
     * 0=系統顏色, 1=黑色, 2=紅色
     */
    private long printFont;
    /**
     * 自動顯示細項
     */
    private long advPrice;
    /**
     * 當金額=0時, 是否打印在帳單上
     */
    private long printToBill;
    /**
     * 額外食品加分
     */
    private double pointsAdd;
    /**
     * 額外積分比率
     */
    private long pointsRatio;
    /**
     * 換購食品所需積分
     */
    private double pointsRedeem;
    /**
     * 是否打印主项
     */
    private long ktPrintMainItem;
    /**
     * 是否打印价格
     */
    private long ktShowPrice;
    /**
     * 0食品清单打印 账单打印//1食品清单不打印 账单不打印//2食品清单打印 账单不打印//3食品清单不打印 账单打印
     */
    private long printTo;
    /**
     * 食品数量是否同步 餐台人数
     */
    private long toPax;
    /**
     * 食品类型 0普通食品 1称重食品
     */
    private long foodType;
    /**
     * gspos自定义表中的Id
     */
    private long majorMainId;
    /**
     * 部门Id
     */
    private long deptId;
    /**
     * 是否收取服務費
     */
    private byte serviceCharge;
    /**
     * 0:新增；1:修改；2:刪除
     */
    private long conditions;
    /**
     * 是否同步 0：否 1：是
     */
    private long isRt;
    /**
     * 是否删除：0正常，1删除
     */
    private long deletes;
    /**
     * 是否時長食物 0=普通食品   1=計費食品  2=免費N小時   3=時段對沖   4=入場費食品
     */
    private long isTimingFood;
    /**
     * 最低持續時間
     */
    private long minLongTime;

    private long unitTime;
    /**
     * 單位價格
     */
    private double unitPrice;
    /**
     * 免費時間(小時)
     */
    private long freeLongTime;
    /**
     * 免費開始時間
     */
    private Date freePeriodBegin;
    /**
     * 是否參與會員喜好統計 0 參與  1 不參與
     */
    private long isStatistic;
    /**
     * 顏色ID
     */
    private long colorId;

    @ToOne(joinProperty = "colorId") //这个是注解绑定 hid就是上面一行的colorId
    private ColorBean colorBean;

    /**
     * 自定義字段
     */

    /**
     * 選中數量
     */
    @Transient
    private int number;
    /**
     * 食品組ID
     */
    @Transient
    private long topId;
    /**
     * 背景顏色
     */
    @Transient
    private int bgColor = Color.parseColor("#03a9f4");
    /**
     * 字體顏色
     */
    @Transient
    private int fontColor = Color.parseColor("#FFFFFF");
    /**
     * 最大選中數
     */
    @Transient
    private String maxNumber = "";
    /**
     * 動態的最大選中數
     */
    @Transient
    private String currentMaxNumber = "";
    /**
     * 是否選中
     */
    @Transient
    private boolean selected;
    /**
     * 是否组合食品
     */
    @Transient
    private boolean isComboFood = false;
    /**
     * Used to resolve relations
     */
    @Generated(hash = 2040040024)
    private transient DaoSession daoSession;
    /**
     * Used for active entity operations.
     */
    @Generated(hash = 1296197325)
    private transient FoodDao myDao;
    @Generated(hash = 292980300)
    private transient Long colorBean__resolvedKey;

    @Generated(hash = 418551587)
    public Food(Long id, long parentId, long restaurantId, byte isParent, long seqNo, String foodName,
                String foodName1, String foodName2, String plu, Integer customType, String posFid, String foodDesc,
                long limitAmount, long limitType, String foodSummary, long invisible, byte autoMod, double price,
                double marketPrice, double lunchboxPrice, String imgUrlSmall, String imageurl, long riceponInvisible,
                double cost, long like, long totalSold, long isSold, Date startDate, Date endDate, String createBy,
                Date createTime, String updateBy, Date updateTime, long periodId, long ableDiscount, long takeaway,
                long blueEdit, long cartEdit, long autoMerge, String printSeting, long isPrintQueueCode,
                long queueHeadId, long approve, long printFont, long advPrice, long printToBill, double pointsAdd,
                long pointsRatio, double pointsRedeem, long ktPrintMainItem, long ktShowPrice, long printTo,
                long toPax, long foodType, long majorMainId, long deptId, byte serviceCharge, long conditions,
                long isRt, long deletes, long isTimingFood, long minLongTime, long unitTime, double unitPrice,
                long freeLongTime, Date freePeriodBegin, long isStatistic, long colorId) {
        this.id = id;
        this.parentId = parentId;
        this.restaurantId = restaurantId;
        this.isParent = isParent;
        this.seqNo = seqNo;
        this.foodName = foodName;
        this.foodName1 = foodName1;
        this.foodName2 = foodName2;
        this.plu = plu;
        this.customType = customType;
        this.posFid = posFid;
        this.foodDesc = foodDesc;
        this.limitAmount = limitAmount;
        this.limitType = limitType;
        this.foodSummary = foodSummary;
        this.invisible = invisible;
        this.autoMod = autoMod;
        this.price = price;
        this.marketPrice = marketPrice;
        this.lunchboxPrice = lunchboxPrice;
        this.imgUrlSmall = imgUrlSmall;
        this.imageurl = imageurl;
        this.riceponInvisible = riceponInvisible;
        this.cost = cost;
        this.like = like;
        this.totalSold = totalSold;
        this.isSold = isSold;
        this.startDate = startDate;
        this.endDate = endDate;
        this.createBy = createBy;
        this.createTime = createTime;
        this.updateBy = updateBy;
        this.updateTime = updateTime;
        this.periodId = periodId;
        this.ableDiscount = ableDiscount;
        this.takeaway = takeaway;
        this.blueEdit = blueEdit;
        this.cartEdit = cartEdit;
        this.autoMerge = autoMerge;
        this.printSeting = printSeting;
        this.isPrintQueueCode = isPrintQueueCode;
        this.queueHeadId = queueHeadId;
        this.approve = approve;
        this.printFont = printFont;
        this.advPrice = advPrice;
        this.printToBill = printToBill;
        this.pointsAdd = pointsAdd;
        this.pointsRatio = pointsRatio;
        this.pointsRedeem = pointsRedeem;
        this.ktPrintMainItem = ktPrintMainItem;
        this.ktShowPrice = ktShowPrice;
        this.printTo = printTo;
        this.toPax = toPax;
        this.foodType = foodType;
        this.majorMainId = majorMainId;
        this.deptId = deptId;
        this.serviceCharge = serviceCharge;
        this.conditions = conditions;
        this.isRt = isRt;
        this.deletes = deletes;
        this.isTimingFood = isTimingFood;
        this.minLongTime = minLongTime;
        this.unitTime = unitTime;
        this.unitPrice = unitPrice;
        this.freeLongTime = freeLongTime;
        this.freePeriodBegin = freePeriodBegin;
        this.isStatistic = isStatistic;
        this.colorId = colorId;
    }

    @Generated(hash = 866324199)
    public Food() {
    }


    /**
     * To-one relationship, resolved on first access.
     */
    @Generated(hash = 972194621)
    public ColorBean getColorBean() {
        long __key = this.colorId;
        if (colorBean__resolvedKey == null || !colorBean__resolvedKey.equals(__key)) {
            final DaoSession daoSession = this.daoSession;
            if (daoSession == null) {
                throw new DaoException("Entity is detached from DAO context");
            }
            ColorBeanDao targetDao = daoSession.getColorBeanDao();
            ColorBean colorBeanNew = targetDao.load(__key);
            synchronized (this) {
                colorBean = colorBeanNew;
                colorBean__resolvedKey = __key;
            }
        }
        return colorBean;
    }

    /**
     * called by internal mechanisms, do not call yourself.
     */
    @Generated(hash = 453682256)
    public void setColorBean(@NotNull ColorBean colorBean) {
        if (colorBean == null) {
            throw new DaoException(
                    "To-one property 'colorId' has not-null constraint; cannot set to-one to null");
        }
        synchronized (this) {
            this.colorBean = colorBean;
            colorId = colorBean.getColorId();
            colorBean__resolvedKey = colorId;
        }
    }

    /**
     * Convenient call for {@link org.greenrobot.greendao.AbstractDao#delete(Object)}.
     * Entity must attached to an entity context.
     */
    @Generated(hash = 128553479)
    public void delete() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }
        myDao.delete(this);
    }

    /**
     * Convenient call for {@link org.greenrobot.greendao.AbstractDao#refresh(Object)}.
     * Entity must attached to an entity context.
     */
    @Generated(hash = 1942392019)
    public void refresh() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }
        myDao.refresh(this);
    }

    /**
     * Convenient call for {@link org.greenrobot.greendao.AbstractDao#update(Object)}.
     * Entity must attached to an entity context.
     */
    @Generated(hash = 713229351)
    public void update() {
        if (myDao == null) {
            throw new DaoException("Entity is detached from DAO context");
        }
        myDao.update(this);
    }

    /**
     * called by internal mechanisms, do not call yourself.
     */
    @Generated(hash = 505459956)
    public void __setDaoSession(DaoSession daoSession) {
        this.daoSession = daoSession;
        myDao = daoSession != null ? daoSession.getFoodDao() : null;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public long getParentId() {
        return this.parentId;
    }

    public void setParentId(long parentId) {
        this.parentId = parentId;
    }

    public long getRestaurantId() {
        return this.restaurantId;
    }

    public void setRestaurantId(long restaurantId) {
        this.restaurantId = restaurantId;
    }

    public byte getIsParent() {
        return this.isParent;
    }

    public void setIsParent(byte isParent) {
        this.isParent = isParent;
    }

    public long getSeqNo() {
        return this.seqNo;
    }

    public void setSeqNo(long seqNo) {
        this.seqNo = seqNo;
    }

    public String getFoodName() {
        return this.foodName;
    }

    public void setFoodName(String foodName) {
        this.foodName = foodName;
    }

    public String getFoodName1() {
        return this.foodName1;
    }

    public void setFoodName1(String foodName1) {
        this.foodName1 = foodName1;
    }

    public String getFoodName2() {
        return this.foodName2;
    }

    public void setFoodName2(String foodName2) {
        this.foodName2 = foodName2;
    }

    public String getPlu() {
        return this.plu;
    }

    public void setPlu(String plu) {
        this.plu = plu;
    }

    public Integer getCustomType() {
        return this.customType;
    }

    public void setCustomType(Integer customType) {
        this.customType = customType;
    }

    public String getPosFid() {
        return this.posFid;
    }

    public void setPosFid(String posFid) {
        this.posFid = posFid;
    }

    public String getFoodDesc() {
        return this.foodDesc;
    }

    public void setFoodDesc(String foodDesc) {
        this.foodDesc = foodDesc;
    }

    public long getLimitAmount() {
        return this.limitAmount;
    }

    public void setLimitAmount(long limitAmount) {
        this.limitAmount = limitAmount;
    }

    public long getLimitType() {
        return this.limitType;
    }

    public void setLimitType(long limitType) {
        this.limitType = limitType;
    }

    public String getFoodSummary() {
        return this.foodSummary;
    }

    public void setFoodSummary(String foodSummary) {
        this.foodSummary = foodSummary;
    }

    public long getInvisible() {
        return this.invisible;
    }

    public void setInvisible(long invisible) {
        this.invisible = invisible;
    }

    public byte getAutoMod() {
        return this.autoMod;
    }

    public void setAutoMod(byte autoMod) {
        this.autoMod = autoMod;
    }

    public double getPrice() {
        return this.price;
    }

    public void setPrice(double price) {
        this.price = price;
    }

    public double getMarketPrice() {
        return this.marketPrice;
    }

    public void setMarketPrice(double marketPrice) {
        this.marketPrice = marketPrice;
    }

    public double getLunchboxPrice() {
        return this.lunchboxPrice;
    }

    public void setLunchboxPrice(double lunchboxPrice) {
        this.lunchboxPrice = lunchboxPrice;
    }

    public String getImgUrlSmall() {
        return this.imgUrlSmall;
    }

    public void setImgUrlSmall(String imgUrlSmall) {
        this.imgUrlSmall = imgUrlSmall;
    }

    public String getImageurl() {
        return this.imageurl;
    }

    public void setImageurl(String imageurl) {
        this.imageurl = imageurl;
    }

    public long getRiceponInvisible() {
        return this.riceponInvisible;
    }

    public void setRiceponInvisible(long riceponInvisible) {
        this.riceponInvisible = riceponInvisible;
    }

    public double getCost() {
        return this.cost;
    }

    public void setCost(double cost) {
        this.cost = cost;
    }

    public long getLike() {
        return this.like;
    }

    public void setLike(long like) {
        this.like = like;
    }

    public long getTotalSold() {
        return this.totalSold;
    }

    public void setTotalSold(long totalSold) {
        this.totalSold = totalSold;
    }

    public long getIsSold() {
        return this.isSold;
    }

    public void setIsSold(long isSold) {
        this.isSold = isSold;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public void setStartDate(Date startDate) {
        this.startDate = startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date endDate) {
        this.endDate = endDate;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getUpdateBy() {
        return this.updateBy;
    }

    public void setUpdateBy(String updateBy) {
        this.updateBy = updateBy;
    }

    public Date getUpdateTime() {
        return this.updateTime;
    }

    public void setUpdateTime(Date updateTime) {
        this.updateTime = updateTime;
    }

    public long getPeriodId() {
        return this.periodId;
    }

    public void setPeriodId(long periodId) {
        this.periodId = periodId;
    }

    public long getAbleDiscount() {
        return this.ableDiscount;
    }

    public void setAbleDiscount(long ableDiscount) {
        this.ableDiscount = ableDiscount;
    }

    public long getTakeaway() {
        return this.takeaway;
    }

    public void setTakeaway(long takeaway) {
        this.takeaway = takeaway;
    }

    public long getBlueEdit() {
        return this.blueEdit;
    }

    public void setBlueEdit(long blueEdit) {
        this.blueEdit = blueEdit;
    }

    public long getCartEdit() {
        return this.cartEdit;
    }

    public void setCartEdit(long cartEdit) {
        this.cartEdit = cartEdit;
    }

    public long getAutoMerge() {
        return this.autoMerge;
    }

    public void setAutoMerge(long autoMerge) {
        this.autoMerge = autoMerge;
    }

    public String getPrintSeting() {
        return this.printSeting;
    }

    public void setPrintSeting(String printSeting) {
        this.printSeting = printSeting;
    }

    public long getIsPrintQueueCode() {
        return this.isPrintQueueCode;
    }

    public void setIsPrintQueueCode(long isPrintQueueCode) {
        this.isPrintQueueCode = isPrintQueueCode;
    }

    public long getQueueHeadId() {
        return this.queueHeadId;
    }

    public void setQueueHeadId(long queueHeadId) {
        this.queueHeadId = queueHeadId;
    }

    public long getApprove() {
        return this.approve;
    }

    public void setApprove(long approve) {
        this.approve = approve;
    }

    public long getPrintFont() {
        return this.printFont;
    }

    public void setPrintFont(long printFont) {
        this.printFont = printFont;
    }

    public long getAdvPrice() {
        return this.advPrice;
    }

    public void setAdvPrice(long advPrice) {
        this.advPrice = advPrice;
    }

    public long getPrintToBill() {
        return this.printToBill;
    }

    public void setPrintToBill(long printToBill) {
        this.printToBill = printToBill;
    }

    public double getPointsAdd() {
        return this.pointsAdd;
    }

    public void setPointsAdd(double pointsAdd) {
        this.pointsAdd = pointsAdd;
    }

    public long getPointsRatio() {
        return this.pointsRatio;
    }

    public void setPointsRatio(long pointsRatio) {
        this.pointsRatio = pointsRatio;
    }

    public double getPointsRedeem() {
        return this.pointsRedeem;
    }

    public void setPointsRedeem(double pointsRedeem) {
        this.pointsRedeem = pointsRedeem;
    }

    public long getKtPrintMainItem() {
        return this.ktPrintMainItem;
    }

    public void setKtPrintMainItem(long ktPrintMainItem) {
        this.ktPrintMainItem = ktPrintMainItem;
    }

    public long getKtShowPrice() {
        return this.ktShowPrice;
    }

    public void setKtShowPrice(long ktShowPrice) {
        this.ktShowPrice = ktShowPrice;
    }

    public long getPrintTo() {
        return this.printTo;
    }

    public void setPrintTo(long printTo) {
        this.printTo = printTo;
    }

    public long getToPax() {
        return this.toPax;
    }

    public void setToPax(long toPax) {
        this.toPax = toPax;
    }

    public long getFoodType() {
        return this.foodType;
    }

    public void setFoodType(long foodType) {
        this.foodType = foodType;
    }

    public long getMajorMainId() {
        return this.majorMainId;
    }

    public void setMajorMainId(long majorMainId) {
        this.majorMainId = majorMainId;
    }

    public long getDeptId() {
        return this.deptId;
    }

    public void setDeptId(long deptId) {
        this.deptId = deptId;
    }

    public byte getServiceCharge() {
        return this.serviceCharge;
    }

    public void setServiceCharge(byte serviceCharge) {
        this.serviceCharge = serviceCharge;
    }

    public long getConditions() {
        return this.conditions;
    }

    public void setConditions(long conditions) {
        this.conditions = conditions;
    }

    public long getIsRt() {
        return this.isRt;
    }

    public void setIsRt(long isRt) {
        this.isRt = isRt;
    }

    public long getDeletes() {
        return this.deletes;
    }

    public void setDeletes(long deletes) {
        this.deletes = deletes;
    }

    public long getIsTimingFood() {
        return this.isTimingFood;
    }

    public void setIsTimingFood(long isTimingFood) {
        this.isTimingFood = isTimingFood;
    }

    public long getMinLongTime() {
        return this.minLongTime;
    }

    public void setMinLongTime(long minLongTime) {
        this.minLongTime = minLongTime;
    }

    public long getUnitTime() {
        return this.unitTime;
    }

    public void setUnitTime(long unitTime) {
        this.unitTime = unitTime;
    }

    public double getUnitPrice() {
        return this.unitPrice;
    }

    public void setUnitPrice(double unitPrice) {
        this.unitPrice = unitPrice;
    }

    public long getFreeLongTime() {
        return this.freeLongTime;
    }

    public void setFreeLongTime(long freeLongTime) {
        this.freeLongTime = freeLongTime;
    }

    public Date getFreePeriodBegin() {
        return this.freePeriodBegin;
    }

    public void setFreePeriodBegin(Date freePeriodBegin) {
        this.freePeriodBegin = freePeriodBegin;
    }

    public long getIsStatistic() {
        return this.isStatistic;
    }

    public void setIsStatistic(long isStatistic) {
        this.isStatistic = isStatistic;
    }

    public long getColorId() {
        return this.colorId;
    }

    public void setColorId(long colorId) {
        this.colorId = colorId;
    }

    public boolean isCustomPrice() {
        if (ableDiscount == 4 || ableDiscount == 5 ) {
            return true;
        }
        return false;
    }

    public boolean isCustomPriceAndName() {
        if (ableDiscount == 2 || ableDiscount == 3) {
            return true;
        }
        return false;
    }

    public int ableDiscountCastCustomType() {
        if (isCustomPriceAndName()) {
            return CUSTOM_TYPE_101;
        }
        if (isCustomPrice()) {
            return CUSTOM_TYPE_102;
        }
        return CUSTOM_TYPE_100;
    }


}
