package com.gingersoft.supply_chain.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.FoodByCategoryResultBean;
import com.gingersoft.supply_chain.mvp.bean.FoodListInfoBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.gingersoft.supply_chain.mvp.server.SupplierServer;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.FragmentScope;

import javax.inject.Inject;

import com.gingersoft.supply_chain.mvp.contract.OtherFunctionContract;

import java.util.Map;

import io.reactivex.Observable;


/**
 * ================================================
 * Created by zjs on 07/07/2021 21:11
 * Description
 * ================================================
 */
@FragmentScope
public class OtherFunctionModel extends BaseModel implements OtherFunctionContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OtherFunctionModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Observable<FoodListInfoBean> getFoodIngredientsData(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getFoodIngredientsData(map);
    }

    @Override
    public Observable<BaseResult> getFoodBySupplierId(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getFoodBySupplierId(map);
    }

    @Override
    public Observable<BaseResult> deleteFood(int foodId) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).deleteFood(foodId);
    }

    @Override
    public Observable<OrderCategoryBean> getCategoryTrees(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getCategoryTrees(map);
    }

    @Override
    public Observable<FoodByCategoryResultBean> getFoodList(Map<String, Object> map) {
        return mRepositoryManager.obtainRetrofitService(SupplierServer.class).getFoodList(map);
    }
}