package com.joe.print.mvp.ui.adapter;

import android.content.Context;
import android.widget.RadioButton;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.BaseViewHolder;
import com.gingersoft.gsa.cloud.base.utils.constans.Constans;
import com.gingersoft.gsa.cloud.base.utils.other.SPUtils;
import com.gingersoft.gsa.cloud.base.utils.toast.ToastUtils;
import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;
import com.joe.print.R;
import com.gingersoft.gsa.cloud.constans.PrintConstans;

import java.util.List;

/**
 * Created by Wyh on 2020/1/16.
 */
public class PrinterListAdapter extends BaseQuickAdapter<PrinterDeviceBean, BaseViewHolder> {
    private Context mContext;
    private int selectPosition = -1;
    private String selectPrintIp;//默認選中的打印機IP
    private Integer selectPrintPort;//默認選中的打印機端口號
    private int paperType;//默認選中的打印機紙張類型

    public PrinterListAdapter(@Nullable List<PrinterDeviceBean> data, Context mContext) {
        super(R.layout.printer_item, data);
        this.mContext = mContext;
        selectPrintIp = (String) SPUtils.get(mContext, PrintConstans.DEFAULT_PRINT_IP, "");
        if ((Integer) SPUtils.get(mContext, PrintConstans.DEFAULT_PRINT_PORT, -1) != -1) {
            selectPrintPort = (int) SPUtils.get(mContext, PrintConstans.DEFAULT_PRINT_PORT, 0);
        }
        paperType = (int) SPUtils.get(mContext, PrintConstans.DEFAULT_PRINT_PAPER, 0);
    }

    @Override
    protected void convert(BaseViewHolder helper, PrinterDeviceBean item) {
        if (selectPosition == -1) {
            //ip、端口、紙張類型也要一致才是默認打印機
            if (selectPrintIp.equals(item.getIp()) && paperType == item.getType()) {
                if (selectPrintPort != null && item.getPort() != null) {
                    if (selectPrintPort.equals(item.getPort())) {
                        ((RadioButton) helper.getView(R.id.cb_printer_item)).setChecked(true);
                        selectPosition = helper.getAdapterPosition();
                    }
                } else if (selectPrintPort == null && item.getPort() == null) {
                    ((RadioButton) helper.getView(R.id.cb_printer_item)).setChecked(true);
                    selectPosition = helper.getAdapterPosition();
                }
            } else {
                ((RadioButton) helper.getView(R.id.cb_printer_item)).setChecked(false);
            }
        } else if (selectPosition == helper.getAdapterPosition()) {
            ((RadioButton) helper.getView(R.id.cb_printer_item)).setChecked(true);
        } else {
            ((RadioButton) helper.getView(R.id.cb_printer_item)).setChecked(false);
        }

        helper.setText(R.id.tv_printer_name, item.getName() + "");
        helper.setText(R.id.tv_printer_ip, String.format(mContext.getString(R.string.print_ip), item.getIp()));
        if (item.getPort() == null) {
            helper.setText(R.id.tv_printer_port, String.format(mContext.getString(R.string.print_port), ""));
        } else {
            helper.setText(R.id.tv_printer_port, String.format(mContext.getString(R.string.print_port), item.getPort() + ""));
        }
//        helper.setOnCheckedChangeListener(R.id.cb_printer_item, (buttonView, isChecked) -> {
//            if (getRecyclerView() != null) {
//                if (getRecyclerView().isComputingLayout()) {//如果recyclerView在刷新時
//                    getRecyclerView().post(() -> setSelectPrint(helper, item, isChecked));
//                } else {
//                    setSelectPrint(helper, item, isChecked);
//                }
//            }
//        });
        helper.setOnClickListener(R.id.cb_printer_item, v -> {
            if (getRecyclerView() != null) {
            if (getRecyclerView().isComputingLayout()) {//如果recyclerView在刷新時
                getRecyclerView().post(() -> setSelectPrint(helper, item, true));
            } else {
                setSelectPrint(helper, item, true);
            }
        }
        });
    }

    /**
     * 設置默認選中打印機
     *
     * @param helper
     * @param item
     * @param isChecked
     */
    private void setSelectPrint(BaseViewHolder helper, PrinterDeviceBean item, boolean isChecked) {
        if (isChecked) {
            SPUtils.put(mContext, PrintConstans.DEFAULT_PRINT_IP, item.getIp());
            SPUtils.put(mContext, PrintConstans.DEFAULT_PRINT_PORT, item.getPort());
            SPUtils.put(mContext, PrintConstans.DEFAULT_PRINT_PAPER, item.getType());
            if (selectPosition != -1) {
                notifyItemChanged(selectPosition);
            }
            selectPosition = helper.getAdapterPosition();
            SPUtils.put(mContext, Constans.DEFAULT_PRINT_METHOD, Constans.IP_PRINT);
            ToastUtils.show(mContext, "已設置默認打印機");
        }
    }

    public int getSelectPosition() {
        return selectPosition;
    }

    public void setSelectPosition(int selectPosition) {
        this.selectPosition = selectPosition;
    }

    public void notifyData(List<PrinterDeviceBean> data) {
        this.mData = data;
        selectPrintIp = (String) SPUtils.get(mContext, PrintConstans.DEFAULT_PRINT_IP, "");
        if (SPUtils.get(mContext, PrintConstans.DEFAULT_PRINT_PORT, null) != null) {
            selectPrintPort = (int) SPUtils.get(mContext, PrintConstans.DEFAULT_PRINT_PORT, 0);
        }
        paperType = (int) SPUtils.get(mContext, PrintConstans.DEFAULT_PRINT_PAPER, 0);
        super.notifyDataSetChanged();
    }
}
