package com.gingersoft.gsa.cloud.ui.widget.dialog;

import android.app.Activity;

import com.gingersoft.gsa.cloud.base.R;
import com.qmuiteam.qmui.widget.dialog.QMUIDialog;
import com.qmuiteam.qmui.widget.dialog.QMUIDialogAction;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-04-03
 * 修订历史：2020-04-03
 * 描述：常用提示Dialog
 */
public class CommonTipDialog {


    /**
     * 提示確認dialog 確認后且執行對應方法
     * @param context
     * @param msg
     * @param c
     * @param object
     * @param methodName
     * @param parameterTypes
     * @param parameters
     */
    public static void showTipAndExecuteMethodDialog(Activity context,String msg,  Class c, Object object, String methodName, Class[] parameterTypes, Object[] parameters) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(context);
        dialogBuilder.setTitle("溫馨提示");
        dialogBuilder.setMessage(msg);
        dialogBuilder.addAction("取消", (dialog, index) -> dialog.dismiss());
        dialogBuilder.addAction(0, "確認", QMUIDialogAction.ACTION_PROP_NEGATIVE, (dialog, index) -> {
            dialog.dismiss();
            try {
                Method method = c.getDeclaredMethod(methodName, parameterTypes);
                method.setAccessible(true);
                method.invoke(object, parameters);
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            } catch (InvocationTargetException e) {
                e.printStackTrace();
            } catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
        });
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }


    public static void showTipDialog(Activity context, String msg) {
        QMUIDialog.MessageDialogBuilder dialogBuilder = new QMUIDialog.MessageDialogBuilder(context);
        dialogBuilder.setTitle("溫馨提示");
        dialogBuilder.setMessage(msg);
        dialogBuilder.addAction("確定", (dialog, index) -> dialog.dismiss());
        dialogBuilder.create(R.style.MyDialogTheme2).show();
    }

}
