package com.gingersoft.gsa.other_order_mode.data.network

import okhttp3.OkHttpClient
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.converter.scalars.ScalarsConverterFactory

object ServiceCreator {

    private const val BASE_URL = "https://hktest.ricepon.com:64377/ricepon-wechat/api/"
    private const val BASE_URL2 = "https://hktest.ricepon.com:64377/member-web/api/"
//https://hktest.ricepon.com:64377/member-web/api/wx/updateRestOpenStatus
    private val httpClient = OkHttpClient.Builder()

    private val builder = Retrofit.Builder()
            .baseUrl(BASE_URL)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    private val builder2 = Retrofit.Builder()
            .baseUrl(BASE_URL2)
            .client(httpClient.build())
            .addConverterFactory(ScalarsConverterFactory.create())
            .addConverterFactory(GsonConverterFactory.create())

    private val retrofit = builder.build()

    private val retrofit2 = builder2.build()

    fun <T> create(serviceClass: Class<T>): T = retrofit.create(serviceClass)

    fun <T> create2(serviceClass: Class<T>): T = retrofit2.create(serviceClass)


}