package com.joe.print.mvp.print.usb;

import android.content.Context;
import android.hardware.usb.UsbDeviceConnection;
import android.hardware.usb.UsbManager;
import android.util.Log;

import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.joe.print.mvp.print.common.SendCallback;
import com.joe.print.mvp.print.common.SendResultCode;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class UsbPrint {

    private final String TAG = "UsbPrint";

    //    private UsbPrint INSTANCE;
    private final UsbManager usbManager;
    private SendCallback sendCallback;
    private final ExecutorService threadPool;

    public UsbPrint(Context context, SendCallback sendCallback) {
        this.usbManager = (UsbManager) context.getSystemService(Context.USB_SERVICE);
        this.sendCallback = sendCallback;
        this.threadPool = Executors.newFixedThreadPool(3);
    }

//    public static UsbPrint getInstance(Context context, SendCallback sendCallback) {
//        if (INSTANCE == null) {
//            synchronized (UsbPrint.class) {
//                if (INSTANCE == null) {
//                    INSTANCE = new UsbPrint(context, sendCallback);
//                }
//            }
//        }
//        return INSTANCE;
//    }

    public void sendPrintCommand(UsbPrinter printer, ArrayList<byte[]> bytes) {
        if (printer == null || printer.getUsbDevice() == null) {
            return;
        }
        SendCommandThread thread = new SendCommandThread(usbManager, printer, bytes);
        threadPool.execute(thread);
    }

    private class SendCommandThread extends Thread {
        private UsbManager usbManager;
        private UsbPrinter usbPrinter;
        private ArrayList<byte[]> bytes;

        public SendCommandThread(UsbManager usbManager, UsbPrinter usbPrinter, ArrayList<byte[]> bytes) {
            this.usbManager = usbManager;
            this.usbPrinter = usbPrinter;
            this.bytes = bytes;
        }

        @Override
        public void run() {
            super.run();
            UsbDeviceConnection connection = usbManager.openDevice(usbPrinter.getUsbDevice());
            if (connection != null && connection.claimInterface(usbPrinter.getUsbInterface(), true)) {
                int result = 0;
                for (int i = 0; i < bytes.size(); i++) {
                    result = connection.bulkTransfer(usbPrinter.getUsbOut(), bytes.get(i), bytes.get(i).length, 5000);
                }
                connection.close();

                int sendResultCode = result > 0 ? SendResultCode.SEND_SUCCESS : SendResultCode.SEND_FAILED;

                LoganManager.w_printer(TAG, "發送結果" + sendResultCode);

                if(usbPrinter != null && sendCallback != null) {
                    sendCallback.onCallback(sendResultCode, usbPrinter.getPrinterName());
                }
            } else {
                LoganManager.w_printer(TAG, "連接失敗");
            }
        }
    }

}
