package com.gingersoft.supply_chain.mvp.ui.adapter;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.BaseSelectorAdapter;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 11:45
 * Use:
 */
public class LeftCategoryAdapter extends BaseSelectorAdapter<CategoryBean, BaseViewHolder> {

    private boolean showDelete = false;

    public LeftCategoryAdapter(@Nullable List<CategoryBean> data) {
        super(R.layout.item_base_category, data);
        addChildClickViewIds(R.id.iv_category_delete);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, CategoryBean categoryBean) {
        viewHolder.setText(R.id.tv_base_item_title, categoryBean.getCategoryName());
        notifyCheckState(viewHolder.getAdapterPosition(), viewHolder.getView(R.id.tv_base_item_title), viewHolder.getView(R.id.item_layout_root));
        viewHolder.setGone(R.id.iv_category_delete, !showDelete);
    }

    @Override
    public void onBindViewHolder(@NotNull BaseViewHolder holder, int position, @NotNull List<Object> payloads) {
        super.onBindViewHolder(holder, position, payloads);
        //list为空时，必须调用两个参数的onBindViewHolder(@NonNull LabelHolder holder, int position)
        if (payloads.isEmpty()) {
            onBindViewHolder(holder, position);
        } else {
            notifyCheckState(position, holder.getView(R.id.tv_base_item_title), holder.getView(R.id.item_layout_root));
        }
    }


    public void setShowDelete(boolean showDelete) {
        this.showDelete = showDelete;
        notifyDataSetChanged();
    }
}
