package com.gingersoft.gsa.cloud.table.mvp.model;

import android.app.Application;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.gsa.cloud.common.rxjava.MyRxSchedulerUtils;
import com.gingersoft.gsa.cloud.table.mvp.model.service.OrderService;
import com.google.gson.Gson;
import com.jess.arms.integration.IRepositoryManager;
import com.jess.arms.mvp.BaseModel;

import com.jess.arms.di.scope.ActivityScope;

import javax.inject.Inject;

import com.gingersoft.gsa.cloud.table.mvp.contract.OrderCenterContract;

import io.reactivex.Single;
import io.reactivex.functions.Function;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 03/13/2020 14:28
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@ActivityScope
public class OrderCenterModel extends BaseModel implements OrderCenterContract.Model {
    @Inject
    Gson mGson;
    @Inject
    Application mApplication;

    @Inject
    public OrderCenterModel(IRepositoryManager repositoryManager) {
        super(repositoryManager);
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        this.mGson = null;
        this.mApplication = null;
    }

    @Override
    public Single<BaseResult> loadOrderList(int restaurantId,String orderType,String status, int pageIndex, int pageSize) {
        return mRepositoryManager.obtainRetrofitService(OrderService.class)
                .loadOrderList(restaurantId, orderType,status,pageIndex, pageSize)
                .compose(MyRxSchedulerUtils._io_main_f());
    }

    @Override
    public Single<BaseResult> cancelOrder(long orderId, int restaurantId,String orderType,String status) {
        return mRepositoryManager.obtainRetrofitService(OrderService.class)
                .cancelOrder(orderId)
                .compose(MyRxSchedulerUtils._io_main_f())
                .flatMap(new Function<BaseResult, Single<BaseResult>>() {
                    @Override
                    public Single<BaseResult> apply(BaseResult info) throws Exception {
                        if (info != null && info.isSuccess()) {
                            return loadOrderList(restaurantId, orderType,status,0, 10);
                        }
                        return Single.just(info);
                    }
                });
    }

}