package com.gingersoft.gsa.cloud.common.function.click;

import android.view.View;

import com.gingersoft.gsa.cloud.common.R;

import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;

import java.util.Calendar;

/**
 *
 * @author Wyh
 * @date 2021/01/13
 */
@Aspect
public class SingleClickAspect {
    static int TIME_TAG = R.id.click_time;

    @Pointcut("execution(@com.gingersoft.gsa.cloud.common.function.click.SingleClick * *(..))")
    public void onSingleClickMethod() {
    }

    /**
     * 對單擊方法進行攔截
     * @param joinPoint
     * @param singleClick
     * @throws Throwable
     */
    @Around("onSingleClickMethod() && @annotation(singleClick)")//在连接点进行方法替换
    public void doSingleClickMethod(ProceedingJoinPoint joinPoint, SingleClick singleClick) throws Throwable {
        View view = null;
        for (Object arg : joinPoint.getArgs()) {
            if (arg instanceof View) {
                view = (View) arg;
            }
        }
        if (view != null) {
            Object tag = view.getTag(TIME_TAG);
            long lastClickTime = ((tag != null) ? (long) tag : 0);
            long currentTime = Calendar.getInstance().getTimeInMillis();
            long value = singleClick.value();
            int[] ids = singleClick.ids();

            if (currentTime - lastClickTime > value || !hasId(ids, view.getId())) {//过滤掉500毫秒内的连续点击
                view.setTag(TIME_TAG, currentTime);
                joinPoint.proceed();//执行原方法
            } else {
                //連點了
            }
        }
    }

    public static boolean hasId(int[] arr, int value) {
        for (int i : arr) {
            if (i == value) {
                return true;
            }
        }
        return false;
    }
}
