package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.widget.TextView;

import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.R;
import com.gingersoft.gsa.cloud.ui.bean.view.CategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/11/28
 * Time: 11:45
 * Use:
 */
public class BaseCategoryAdapter extends BaseQuickAdapter<CategoryBean, BaseViewHolder> {

    private int selectedIndex = 0;
    private int selectedBg;
    private int unSelectedBg;

    private int selectColor = -1;
    private int unSelectColor = -1;
    private boolean showDelete = false;

    public BaseCategoryAdapter(@Nullable List<CategoryBean> data) {
        super(R.layout.item_base_category, data);
        addChildClickViewIds(R.id.iv_category_delete);
        selectedBg = R.drawable.shape_left_radio_shadow;
        unSelectedBg = R.color.trans;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, CategoryBean categoryBean) {
        TextView tvCategoryName = viewHolder.getView(R.id.tv_category_name);
        tvCategoryName.setText(categoryBean.getCategoryName());
        CardView view = viewHolder.getView(R.id.layout_category);
        if (viewHolder.getAdapterPosition() == selectedIndex) {
            view.setBackground(ContextCompat.getDrawable(getContext(), selectedBg));
            if (selectColor != -1) {
                tvCategoryName.setTextColor(selectColor);
            }
            tvCategoryName.setSelected(true);
        } else {
            tvCategoryName.setSelected(false);
            view.setBackground(ContextCompat.getDrawable(getContext(), unSelectedBg));
            if (unSelectColor != -1) {
                tvCategoryName.setTextColor(unSelectColor);
            }
        }
        viewHolder.setGone(R.id.iv_category_delete, !showDelete);
    }

    public void setShowDelete(boolean showDelete) {
        this.showDelete = showDelete;
        notifyDataSetChanged();
    }

    public BaseCategoryAdapter setSelectedBg(int selectedBg) {
        this.selectedBg = selectedBg;
        return this;
    }

    public BaseCategoryAdapter setUnSelectedBg(int unSelectedBg) {
        this.unSelectedBg = unSelectedBg;
        return this;
    }

    public BaseCategoryAdapter setSelectColor(int selectColor) {
        this.selectColor = selectColor;
        return this;
    }

    public BaseCategoryAdapter setUnSelectColor(int unSelectColor) {
        this.unSelectColor = unSelectColor;
        return this;
    }

    public void setSelectedIndex(int selectedIndex) {
        this.selectedIndex = selectedIndex;
        notifyDataSetChanged();
    }

    public int getSelectedIndex() {
        return selectedIndex;
    }
}
