package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;

import androidx.core.content.ContextCompat;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.InventoryRecordBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.sql.Time;
import java.util.List;

import cn.bingoogolapple.baseadapter.BGABaseAdapterUtil;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/13
 * Time: 10:02
 * Use:
 */
public class InventoryRecordAdapter extends BaseQuickAdapter<InventoryRecordBean, BaseViewHolder> {
    private int[] colors = new int[]{R.color.color_f9, R.color.white};

    public InventoryRecordAdapter(@Nullable List<InventoryRecordBean> data) {
        super(R.layout.item_inventory_record, data);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, InventoryRecordBean inventoryRecordBean) {
        viewHolder.setText(R.id.tv_inventory_record_username, inventoryRecordBean.getUserName());
        viewHolder.setText(R.id.tv_inventory_record_number, String.valueOf(inventoryRecordBean.getRemainingQuantity()));
        viewHolder.setText(R.id.tv_inventory_record_difference, String.valueOf(inventoryRecordBean.getConsumeQuantity()));
        viewHolder.setText(R.id.tv_inventory_record_operating_data, TimeUtils.getTime(inventoryRecordBean.getCreateTime(), TimeUtils.DEFAULT_DATE_FORMAT));

        viewHolder.setTextColor(R.id.tv_inventory_record_username, ContextCompat.getColor(getContext(), R.color.color_3c));
        viewHolder.setTextColor(R.id.tv_inventory_record_number, ContextCompat.getColor(getContext(), R.color.color_3c));
        viewHolder.setTextColor(R.id.tv_inventory_record_difference, ContextCompat.getColor(getContext(), R.color.color_3c));
        viewHolder.setTextColor(R.id.tv_inventory_record_operating_data, ContextCompat.getColor(getContext(), R.color.color_3c));

        viewHolder.setBackgroundColor(R.id.layout_inventory_record, BGABaseAdapterUtil.getColor(colors[viewHolder.getAdapterPosition() % 2]));

        if (inventoryRecordBean.getConsumeQuantity() > 0) {
            viewHolder.setTextColor(R.id.tv_inventory_record_difference, ContextCompat.getColor(getContext(), R.color.required_color));
        } else {
            viewHolder.setTextColor(R.id.tv_inventory_record_difference, ContextCompat.getColor(getContext(), R.color.purchase_buy_again_color));
        }
    }


}
