/*
 * Decompiled with CFR 0.152.
 */
package com.epson.eposdevice.keyboard;

import com.epson.eposdevice.EposException;
import com.epson.eposdevice.keyboard.KeyPressListener;
import com.epson.eposdevice.keyboard.NativeKeyboard;
import com.epson.eposdevice.keyboard.StringListener;

public abstract class Keyboard
extends NativeKeyboard {
    public static final byte VK_BACK = 8;
    public static final byte VK_TAB = 9;
    public static final byte VK_RETURN = 13;
    public static final byte VK_SHIFT = 16;
    public static final byte VK_CONTROL = 17;
    public static final byte VK_MENU = 18;
    public static final byte VK_CAPITAL = 20;
    public static final byte VK_ESCAPE = 27;
    public static final byte VK_CONVERT = 28;
    public static final byte VK_NONCONVERT = 29;
    public static final byte VK_SPACE = 32;
    public static final byte VK_PRIOR = 33;
    public static final byte VK_NEXT = 34;
    public static final byte VK_END = 35;
    public static final byte VK_HOME = 36;
    public static final byte VK_LEFT = 37;
    public static final byte VK_UP = 38;
    public static final byte VK_RIGHT = 39;
    public static final byte VK_DOWN = 40;
    public static final byte VK_INSERT = 45;
    public static final byte VK_DELETE = 46;
    public static final byte VK_0 = 48;
    public static final byte VK_1 = 49;
    public static final byte VK_2 = 50;
    public static final byte VK_3 = 51;
    public static final byte VK_4 = 52;
    public static final byte VK_5 = 53;
    public static final byte VK_6 = 54;
    public static final byte VK_7 = 55;
    public static final byte VK_8 = 56;
    public static final byte VK_9 = 57;
    public static final byte VK_A = 65;
    public static final byte VK_B = 66;
    public static final byte VK_C = 67;
    public static final byte VK_D = 68;
    public static final byte VK_E = 69;
    public static final byte VK_F = 70;
    public static final byte VK_G = 71;
    public static final byte VK_H = 72;
    public static final byte VK_I = 73;
    public static final byte VK_J = 74;
    public static final byte VK_K = 75;
    public static final byte VK_L = 76;
    public static final byte VK_M = 77;
    public static final byte VK_N = 78;
    public static final byte VK_O = 79;
    public static final byte VK_P = 80;
    public static final byte VK_Q = 81;
    public static final byte VK_R = 82;
    public static final byte VK_S = 83;
    public static final byte VK_T = 84;
    public static final byte VK_U = 85;
    public static final byte VK_V = 86;
    public static final byte VK_W = 87;
    public static final byte VK_X = 88;
    public static final byte VK_Y = 89;
    public static final byte VK_Z = 90;
    public static final byte VK_MULTIPLY = 106;
    public static final byte VK_ADD = 107;
    public static final byte VK_SUBTRACT = 109;
    public static final byte VK_F1 = 112;
    public static final byte VK_F2 = 113;
    public static final byte VK_F3 = 114;
    public static final byte VK_F4 = 115;
    public static final byte VK_F5 = 116;
    public static final byte VK_F6 = 117;
    public static final byte VK_F7 = 118;
    public static final byte VK_F8 = 119;
    public static final byte VK_F9 = 120;
    public static final byte VK_F10 = 121;
    public static final byte VK_F11 = 122;
    public static final byte VK_F12 = 123;
    public static final byte VK_OEM_1 = -70;
    public static final byte VK_OEM_PLUS = -69;
    public static final byte VK_OEM_COMMA = -68;
    public static final byte VK_OEM_MINUS = -67;
    public static final byte VK_OEM_PERIOD = -66;
    public static final byte VK_OEM_2 = -65;
    public static final byte VK_OEM_3 = -64;
    public static final byte VK_OEM_4 = -37;
    public static final byte VK_OEM_5 = -36;
    public static final byte VK_OEM_6 = -35;
    public static final byte VK_OEM_7 = -34;
    public static final byte VK_OEM_ATTN = -16;
    private KeyPressListener mKeyPressListener = null;
    private StringListener mStringListener = null;
    private long mKbdHandle = 0L;

    private void OnKbdKeyPress(String ipAddress, String deviceId, int keyCode, String ascii) {
        if (null != this.mKeyPressListener) {
            this.outputLogEvent("onKbdKeyPress", ipAddress, deviceId, keyCode, ascii);
            this.mKeyPressListener.onKbdKeyPress(ipAddress, deviceId, keyCode, ascii);
        }
    }

    private void OnKbdString(String ipAddress, String deviceId, String input, int prefix) {
        if (null != this.mStringListener) {
            this.outputLogEvent("onKbdString", ipAddress, deviceId, input, prefix);
            this.mStringListener.onKbdString(ipAddress, deviceId, input, prefix);
        }
    }

    protected Keyboard(long kbdHandle) {
        this.mKbdHandle = kbdHandle;
    }

    protected long getInnerHandle() {
        return this.mKbdHandle;
    }

    protected void innerDeleteInstance() {
        this.nativeSetKbdKeyPressCallback(this.mKbdHandle, null);
        this.nativeSetKbdStringCallback(this.mKbdHandle, null);
        this.mKbdHandle = 0L;
    }

    protected void checkHandle() throws EposException {
        if (this.mKbdHandle == 0L) {
            throw new EposException(255);
        }
    }

    public void setPrefix(byte[] data) throws EposException {
        this.outputLogCallFunction("setPrefix", new Object[]{data});
        try {
            this.checkHandle();
            int result = this.nativeKbdSetPrefix(this.mKbdHandle, data);
            if (result != 0) {
                throw new EposException(result);
            }
        }
        catch (EposException ex) {
            this.outputException("setPrefix", ex);
            throw ex;
        }
        this.outputLogReturnFunction("setPrefix", new Object[]{data});
    }

    public void setKeyPressEventCallback(KeyPressListener target) {
        if (this.mKbdHandle != 0L) {
            if (target != null) {
                this.mKeyPressListener = target;
                this.nativeSetKbdKeyPressCallback(this.mKbdHandle, this);
            } else {
                this.nativeSetKbdKeyPressCallback(this.mKbdHandle, null);
                this.mKeyPressListener = null;
            }
        }
    }

    public void setStringEventCallback(StringListener target) {
        if (this.mKbdHandle != 0L) {
            if (target != null) {
                this.mStringListener = target;
                this.nativeSetKbdStringCallback(this.mKbdHandle, this);
            } else {
                this.nativeSetKbdStringCallback(this.mKbdHandle, null);
                this.mStringListener = null;
            }
        }
    }

    @Override
    protected void nativeOnKbdKeyPress(String ipAddress, String deviceId, int keyCode, String ascii) {
        this.OnKbdKeyPress(ipAddress, deviceId, keyCode, ascii);
    }

    @Override
    protected void nativeOnKbdString(String ipAddress, String deviceId, String input, int prefix) {
        this.OnKbdString(ipAddress, deviceId, input, prefix);
    }

    protected abstract void outputLogCallFunction(String var1, Object ... var2);

    protected abstract void outputLogReturnFunction(String var1, Object ... var2);

    protected abstract void outputException(String var1, Exception var2);

    protected abstract void outputLogEvent(String var1, Object ... var2);
}

