package com.gingersoft.supply_chain.di.component;

import com.gingersoft.supply_chain.di.module.DishesModule;
import com.gingersoft.supply_chain.mvp.contract.DishesContract;
import com.gingersoft.supply_chain.mvp.ui.fragment.DishesFragment;
import com.jess.arms.di.component.AppComponent;
import com.jess.arms.di.scope.FragmentScope;

import dagger.BindsInstance;
import dagger.Component;

/**
 * ================================================
 * ================================================
 */
@FragmentScope
@Component(modules = DishesModule.class, dependencies = AppComponent.class)
public interface DishesComponent {

    void inject(DishesFragment fragment);

    @Component.Builder
    interface Builder {

        @BindsInstance
        DishesComponent.Builder view(DishesContract.View view);

        DishesComponent.Builder appComponent(AppComponent appComponent);

        DishesComponent build();
    }
}


