package com.gingersoft.supply_chain.mvp.bean;

import com.gingersoft.gsa.cloud.common.constans.AppConstant;
import com.gingersoft.supply_chain.mvp.ui.adapter.dishes.DishNode;

import java.util.List;

import lombok.Data;

@Data
public class DishDetailBean {

  private Integer id;
  private int biFoodId;//	非必须		菜品ID
  private String dishesName;//	非必须		菜品名称
  private int brandId;//	 number	非必须
  private int restaurantId;//	number	非必须
  private int purchaseFoodId;//	number	非必须		食材编号
  private String foodName;//	string	非必须		食材名称
  private double consumeQuantity;//	number	非必须		消耗个数
  private String basicUnitName;//	string	非必须		配置单位
  private String foodNo;//	string	非必须		食材编号
  private int type;//	number	非必须		状态 0 食材 1 细项
  private boolean deletes;//		非必须		删除 false 未删除 true 删除
  private String foodBasicUnit;//	string	非必须		食材基本单位
  private List<DeputyUnitBean> foodUnits;

  public DishDetailBean(PurchaseFoodBean foodBean , DishNode dishNode ) {
//    this.id = foodBean.get; ///此时的 id 一定是null deletes必是f
    this.deletes = false;
    this.foodBasicUnit = foodBean.getBasicUnitName();
    this.biFoodId = dishNode.getId();
    this.dishesName = dishNode.getFoodName();
    this.brandId = AppConstant.getBrandId();
    this.restaurantId = AppConstant.getRestaurantId();
    this.purchaseFoodId =  foodBean.getId();;
    this.foodName =  foodBean.getName();
    this.consumeQuantity = foodBean.getFoodQuantity();
    this.basicUnitName = foodBean.getBasicUnitName();
    this.foodNo = foodBean.getFoodNo();
    this.type = 0;
    this.foodUnits = foodBean.getFoodUnits();
  }
}
