package com.gingersoft.supply_chain.mvp.bean;

import java.util.List;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/24
 * Time: 14:14
 * Use: 入庫接口上傳實體類
 */
@Data
public class OrderWareHouseBean {
    private int status;
    private Integer orderId;
//    private List<String> encodeFoodNos;

    private List<PurchaseConsumeVerifyEncodeSn> purchaseConsumeVerifyEncodeSn;
    private PurchaseWarehousingOrder purchaseWarehousingOrder;
    private List<PurchaseWarehousingOrderDetail> purchaseWarehousingOrderDetailsTOS;

    @Data
    public static class PurchaseWarehousingOrder {
        /**
         * 訂單圖片，多張，用逗號分隔
         */
        private String files;
        private String remarks;
        private double totalPrice;
        private int supplierId;
        private int brandId;
        private int restaurantId;
        //入庫原因，字符串
        private String storageType;
    }

    @Data
    public static class PurchaseWarehousingOrderDetail {
        private Integer orderDetailsId;
        private Integer purchaseFoodId;
        private double foodQuantity;
        private double foodPrice;
        private double totalPrice;
        private int brandId;
        private int restaurantId;
        /**
         * 主單位名稱
         */
        private String basicUnitName;
        /**
         * 主單位內容
         */
        private double basicUnitValue;
        /**
         * 副單位
         */
        private WareHousingUnitBean purchaseWarehousingUnit;
        /**
         * sn碼
         */
        private List<PurchaseFoodEncodeSn> purchaseFoodEncodeSn;

        private int supplierId;
    }

    @Data
    public static class PurchaseConsumeVerifyEncodeSn {
        public PurchaseConsumeVerifyEncodeSn(String encodeFoodNo, List<String> encodeSnNos) {
            this.encodeFoodNo = encodeFoodNo;
            this.encodeSnNos = encodeSnNos;
        }

        private String encodeFoodNo;
        private List<String> encodeSnNos;
    }

}
