package com.gingersoft.supply_chain.mvp.contract;

import com.gingersoft.gsa.cloud.common.bean.BaseResult;
import com.gingersoft.supply_chain.mvp.bean.BuyIngredientsBean;
import com.gingersoft.supply_chain.mvp.bean.FoodByCategoryResultBean;
import com.gingersoft.supply_chain.mvp.bean.FoodListInfoBean;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;
import com.jess.arms.mvp.IModel;
import com.jess.arms.mvp.IView;

import java.util.List;
import java.util.Map;

import io.reactivex.Observable;


/**
 * ================================================
 * Created by zjs on 07/07/2021 21:11
 * Description
 * ================================================
 */
public interface OtherFunctionContract {
    interface View extends IView {
        /**
         * 加載分類
         *
         * @param foodCategoryTrees 所有分類層級信息
         */
        void initCategoryInfo(List<OrderCategoryBean.FoodCategoryTrees> foodCategoryTrees);

        /**
         * 加載失敗
         */
        void loadFail();

        /**
         * 結束加載並且沒有更多數據了
         */
        void finishLoad(boolean noData);

        /**
         * 加載食品
         *
         * @param buyIngredientsBeans 顯示的食材
         * @param addToHead           是否添加到頭部
         * @param isReset             是否重新設置數據
         */
        void loadFood(List<BuyIngredientsBean> buyIngredientsBeans, boolean addToHead, boolean isReset);

        void selectFirstCategoryByIndex(int position);

        /**
         * 食材列表滾動到指定位置
         *
         * @param index 指定位置
         */
        void scrollToPosition(int index);
    }

    //Model层定义接口,外部只需关心Model返回的数据,无需关心内部细节,即是否使用缓存
    interface Model extends IModel {
        Observable<FoodListInfoBean> getFoodIngredientsData(Map<String, Object> map);

        Observable<BaseResult> getFoodBySupplierId(Map<String, Object> map);

        Observable<BaseResult> deleteFood(int foodId);

        Observable<OrderCategoryBean> getCategoryTrees(Map<String, Object> map);

//        Observable<DishesResultBean> getFoodList(Map<String, Object> map);
        Observable<FoodByCategoryResultBean> getFoodByCategory(Map<String, Object> map);
    }
}
