package com.gingersoft.supply_chain.mvp.ui.adapter.dishes;

import androidx.annotation.Nullable;

import com.chad.library.adapter.base.entity.node.BaseExpandNode;
import com.chad.library.adapter.base.entity.node.BaseNode;
import com.gingersoft.supply_chain.mvp.bean.DishDetailResultBean;

import java.util.ArrayList;
import java.util.List;

public class DishNode extends BaseExpandNode {
    private int id;
    private int parentId;
    private int restaurantId;
    private boolean isParent;
    private int seqNo;
    private String foodName;
    private boolean isSelect;

    private List<BaseNode> childNode;
    //判断是否有配置过
    private DishDetailResultBean detailBean;

    public void addChildNode(BaseNode baseNode) {
        if (baseNode == null) {
            return;
        }
        if (childNode == null) {
            childNode = new ArrayList<>();
        }
        childNode.add(baseNode);
    }

    public boolean isSelect() {
        return isSelect;
    }

    public DishDetailResultBean getDetailBean() {
        return detailBean;
    }

    public void setDetailBean(DishDetailResultBean detailBean) {
        this.detailBean = detailBean;
    }

    public void setSelect(boolean select) {
        isSelect = select;
    }

    public int getId() {
        return id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int getParentId() {
        return parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public int getRestaurantId() {
        return restaurantId;
    }

    public void setRestaurantId(int restaurantId) {
        this.restaurantId = restaurantId;
    }

    public boolean isParent() {
        return isParent;
    }

    public void setParent(boolean parent) {
        isParent = parent;
    }

    public int getSeqNo() {
        return seqNo;
    }

    public void setSeqNo(int seqNo) {
        this.seqNo = seqNo;
    }

    public String getFoodName() {
        return foodName;
    }

    public void setFoodName(String foodName) {
        this.foodName = foodName;
    }

    public DishNode(List<BaseNode> childNode) {
        this.childNode = childNode;

        setExpanded(false);
    }
 
    public String getTitle() {
        return foodName;
    }

    @Override
    public String toString() {
        return "DishNode{" +
                "id=" + id +
                ", parentId=" + parentId +
                ", restaurantId=" + restaurantId +
                ", isParent=" + isParent +
                ", seqNo=" + seqNo +
                ", foodName='" + foodName + '\'' +
                ", isSelect=" + isSelect +
                ", childNode=" + childNode +
                ", detailBean=" + detailBean +
                '}';
    }

    @Nullable
    @Override
    public List<BaseNode> getChildNode() {
        return childNode;
    }
}