package com.gingersoft.gsa.cloud.common.utils;

import android.os.Build;

/**
 * @作者: bin
 * @創建時間: 2020-12-26 10:49
 * @更新時間: 2020-12-26 10:49
 * @描述:
 */
public class AppDevices {


    /**
     * 是不是支付POS設備
     *
     * @return
     */
    public static final boolean isPosPay() {
        if (isYedpay()) {
            return true;
        }
        if (isHywebPos()) {
            return true;
        }
        if (isBBPos()) {
            return true;
        }
        return false;
    }

    /**
     * 是不是N5設備
     *
     * @return
     */
    public static final boolean isHywebPos() {
        String model = Build.MODEL;
        if ("N5".contains(model)) {
            return true;
        }
        return false;
    }

    /**
     * 是不是BBPOS設備
     *
     * @return
     */
    public static final boolean isBBPos() {
        String model = Build.MODEL;
        if ("BBPOS".contains(model)) {
            return true;
        }
        return false;
    }


    /**
     * 是不是Yedpay設備
     *
     * @return
     */
    public static final boolean isYedpay() {
        String model = Build.MODEL;
        if ("Yedpay".contains(model)) {
            return true;
        }
        return false;
    }

    /**
     * 是不是商米設備
     *
     * @return
     */
    public static final boolean isSunmi() {
        String model = Build.MODEL;
        if ("V2,V2_PRO".contains(model)) {
            return true;
        }
        return false;
    }

}
