package com.gingersoft.gsa.cloud.login.mvp.ui.adapter;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.common.utils.time.TimeUtils;
import com.gingersoft.gsa.cloud.login.R;
import com.gingersoft.gsa.cloud.login.mvp.bean.LoginLimitBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.List;

public class LoginLimitAdapter extends BaseQuickAdapter<LoginLimitBean, BaseViewHolder> {

    public LoginLimitAdapter(@Nullable List<LoginLimitBean> data) {
        super(R.layout.login_limit_item, data);
        addChildClickViewIds(R.id.tv_login_limit_operation);
    }

    @Override
    protected void convert(@NotNull BaseViewHolder baseViewHolder,LoginLimitBean loginLimitBean) {
        baseViewHolder.setText(R.id.tv_login_limit_account, loginLimitBean.getUserName());
        baseViewHolder.setText(R.id.tv_login_limit_time, TimeUtils.getStringByFormat(loginLimitBean.getDateTime(), TimeUtils.DEFAULT_DATE_FORMAT));
    }
}
