package com.gingersoft.gsa.cloud.login.mvp.ui.activity.di.module;

import com.jess.arms.di.scope.ActivityScope;

import dagger.Module;
import dagger.Provides;

import com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.contract.RecoverPasswordContract;
import com.gingersoft.gsa.cloud.login.mvp.ui.activity.mvp.model.RecoverPasswordModel;


@Module
public class RecoverPasswordModule {
    private RecoverPasswordContract.View view;

    /**
     * 构建RecoverPasswordModule时,将View的实现类传进来,这样就可以提供View的实现类给presenter
     * @param view
     */
    public RecoverPasswordModule(RecoverPasswordContract.View view) {
        this.view = view;
    }

    @ActivityScope
    @Provides
    RecoverPasswordContract.View provideRecoverPasswordView(){
        return this.view;
    }

    @ActivityScope
    @Provides
    RecoverPasswordContract.Model provideRecoverPasswordModel(RecoverPasswordModel model){
        return model;
    }
}