package com.joe.print.mvp.ui.view;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.annotation.NonNull;

import com.airbnb.lottie.LottieAnimationView;
import com.gingersoft.gsa.cloud.common.logan.LoganManager;
import com.gingersoft.gsa.cloud.pay.pos.hywebpos.constant.HywebActionStatusCode;
import com.gingersoft.gsa.cloud.ui.widget.dialog.BaseRetryDialog;
import com.joe.print.R;
import com.qmuiteam.qmui.layout.QMUILinearLayout;
import com.qmuiteam.qmui.util.QMUIDisplayHelper;

import java.util.concurrent.atomic.AtomicInteger;

import butterknife.BindDrawable;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.functions.Consumer;

/**
 * 作者：ELEGANT_BIN
 * 版本：1.6.0
 * 创建日期：2020-03-28
 * 修订历史：2020-03-28
 * 描述：
 */
public class PrinterLoadingDialog extends BaseRetryDialog {

    private static final String TAG = "PrinterLoadingDialog";

    private Activity mContext;

    private TextView tv_generate_print_data, tv_connecting, tv_print_result, tv_error_msg;

    public static final byte status_default = 0;
    public static final byte status_success = 1;
    public static final byte status_error = 2;

    private int mRadius;
    private float mShadowAlpha = 0.25f;
    private int mShadowElevationDp = 14;

    public PrinterLoadingDialog(@NonNull Activity context) {
        super(context, R.style.MyDialogTheme2);
        mContext = context;
        mRadius = QMUIDisplayHelper.dp2px(mContext, 8);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        setCanceledOnTouchOutside(true);
    }

    @Override
    public void show() {
        super.show();
    }

    @Override
    public void dismiss() {
        super.dismiss();
    }

    public PrinterLoadingDialog build() {
        View contentView = buildViews();
        int screenWidth = (int) (QMUIDisplayHelper.getScreenWidth(mContext) * 0.85);
        int screenHeight = (int) (QMUIDisplayHelper.getScreenHeight(mContext) * 0.5);
        setContentView(contentView, new LinearLayout.LayoutParams(screenWidth, screenHeight));
        return this;
    }

    private View buildViews() {
        View view = View.inflate(mContext, getContentViewLayoutId(), null);
        QMUILinearLayout ll_container = view.findViewById(R.id.ll_container);
        LottieAnimationView printLottieView = view.findViewById(R.id.lottieAnimationView);
        tv_generate_print_data = view.findViewById(R.id.tv_generate_print_data);
        tv_connecting = view.findViewById(R.id.tv_connecting);
        tv_print_result = view.findViewById(R.id.tv_print_result);
        tv_error_msg = view.findViewById(R.id.tv_error_msg);

        ll_container.setRadiusAndShadow(mRadius, QMUIDisplayHelper.dp2px(mContext, mShadowElevationDp), mShadowAlpha);

        printLottieView.setAnimation(R.raw.printer_loading3);
        printLottieView.loop(true);
//        printLottieView.addAnimatorUpdateListener((animation) -> {
//            // Do something.动画状态监听回调
//
//        });
        printLottieView.playAnimation();//播放动画
        return view;
    }

    public void setStep(int step, int status, String errorMsg) {
        mContext.runOnUiThread(new Runnable() {
            @Override
            public void run() {
                setPrintStateText(step, status, errorMsg);
            }
        });
    }

    private void setPrintStateText(int step, int status, String errorMsg) {
        if (!TextUtils.isEmpty(errorMsg)) {
            tv_error_msg.setText(errorMsg);
            tv_error_msg.setVisibility(View.VISIBLE);
        } else {
            tv_error_msg.setVisibility(View.GONE);
        }
        switch (step) {
            case 1:
                if (status == PrinterLoadingDialog.status_success) {
                    tv_generate_print_data.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_green_point), null, null);
                } else if (status == PrinterLoadingDialog.status_error) {
                    tv_generate_print_data.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_red_point), null, null);
                } else {
                    tv_generate_print_data.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_grey_point), null, null);
                }
                break;
            case 2:
                tv_generate_print_data.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_green_point), null, null);
                if (status == PrinterLoadingDialog.status_success) {
                    tv_connecting.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_green_point), null, null);
                } else if (status == PrinterLoadingDialog.status_error) {
                    tv_connecting.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_red_point), null, null);
                } else {
                    tv_connecting.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_grey_point), null, null);
                }
                break;
            case 3:
                if (status == PrinterLoadingDialog.status_success) {
                    tv_print_result.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_green_point), null, null);
                } else if (status == PrinterLoadingDialog.status_error) {
                    tv_print_result.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_red_point), null, null);
                } else {
                    tv_print_result.setCompoundDrawables(null, getDrawableByResId(R.drawable.print_grey_point), null, null);
                }
                break;
            default:
                break;
        }
        setStatusResult(step, status);
    }

    private void setStatusResult(int step, int status) {
        switch (step) {
            case 2:
                tv_generate_print_data.setText("生成成功");
                if (status == PrinterLoadingDialog.status_success) {
                    tv_connecting.setText("連接成功");
                } else if (status == PrinterLoadingDialog.status_error) {
                    tv_connecting.setText("連接失敗");
                } else {
                    tv_connecting.setText("連接中");
                }
                break;
            case 3:
                if (status == PrinterLoadingDialog.status_success) {
                    tv_connecting.setText("打印成功");
                } else if (status == PrinterLoadingDialog.status_error) {
                    tv_connecting.setText("打印失敗");
                } else {
                    tv_connecting.setText("打印結果");
                }
                break;
            default:
                break;
        }
    }

    private Drawable getDrawableByResId(int resId) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            Drawable drawable = mContext.getDrawable(resId);
            drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
            return drawable;
        }
        Drawable drawable = mContext.getResources().getDrawable(resId);
        drawable.setBounds(0, 0, drawable.getMinimumWidth(), drawable.getMinimumHeight());
        return drawable;
    }

    protected int getContentViewLayoutId() {
        return R.layout.print_dialog_loading;
    }

}
