package com.gingersoft.gsa.cloud.ui.adapter.multi;

import android.view.LayoutInflater;
import android.view.ViewGroup;

import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.gsa.cloud.ui.R;
import com.gingersoft.gsa.cloud.ui.adapter.bean.InfoMultiBean;

import org.jetbrains.annotations.NotNull;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/10/29
 * Time: 15:58
 * Use: 備註輸入框樣式
 */
public class RemarkProvider<T extends InfoMultiBean> extends InputProvider<T> {
    public final static int REMARK_TEXT_LENGTH = 50;

    @Override
    public int getItemViewType() {
        return InfoMultiBean.ITEM_MULTIPLE_INPUT_REMARK;
    }

    @Override
    public int getLayoutId() {
        return R.layout.multi_input_remark;
    }

    @Override
    public @NotNull InputViewHolder onCreateViewHolder(@NotNull ViewGroup parent, int viewType) {
        return new InputViewHolder(LayoutInflater.from(context).inflate(getLayoutId(), parent, false));
    }

    @Override
    public void convert(@NotNull BaseViewHolder baseViewHolder, T t) {
        super.convert(baseViewHolder, t);
    }
}
