package com.gingersoft.supply_chain.mvp.bean;

import java.io.Serializable;
import java.util.List;
import java.util.Objects;

import lombok.Data;

/**
 * @author 宇航.
 * User: admin
 * Date: 2020/12/8
 * Time: 16:24
 * Use: 下單頁面的分類
 */
@Data
public class OrderCategoryBean implements Serializable {

    private boolean success;
    private long sysTime;
    private String errMsg;
    private List<FoodCategoryTrees> data;

    @Data
    public static class FoodCategoryTrees {
        private int id;
        private String name;
        private int parentId;
        private int size;
        private List<FoodCategoryTrees> foodCategoryTrees;
        /**
         * 該分類下的食材信息，需要從接口獲取
         */
        private List<PurchaseFoodBean> foodInfo;

        public FoodCategoryTrees() {
        }

        public FoodCategoryTrees(int id, String name, int parentId) {
            this.id = id;
            this.name = name;
            this.parentId = parentId;
        }

        public FoodCategoryTrees(int id) {
            this.id = id;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            FoodCategoryTrees that = (FoodCategoryTrees) o;
            return id == that.id &&
                    parentId == that.parentId &&
                    Objects.equals(name, that.name);
        }

        @Override
        public int hashCode() {
            return Objects.hash(id, name, parentId);
        }
    }


}
