package com.gingersoft.gsa.cloud.table.di.module;

import com.gingersoft.gsa.cloud.ui.adapter.TagViewAdapter;
import com.gingersoft.gsa.cloud.ui.bean.TagViewItem;
import com.jess.arms.di.scope.ActivityScope;
import com.jess.arms.di.scope.FragmentScope;

import dagger.Binds;
import dagger.Module;
import dagger.Provides;

import com.gingersoft.gsa.cloud.table.mvp.contract.BillDiscountContract;
import com.gingersoft.gsa.cloud.table.mvp.model.BillDiscountModel;

import java.util.ArrayList;
import java.util.List;


/**
 * ================================================
 * Description:
 * <p>
 * Created by MVPArmsTemplate on 04/02/2021 17:26
 * <a href="mailto:jess.yan.effort@gmail.com">Contact me</a>
 * <a href="https://github.com/JessYanCoding">Follow me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms">Star me</a>
 * <a href="https://github.com/JessYanCoding/MVPArms/wiki">See me</a>
 * <a href="https://github.com/JessYanCoding/MVPArmsTemplate">模版请保持更新</a>
 * ================================================
 */
@Module
public abstract class BillDiscountModule {

    @Binds
    abstract BillDiscountContract.Model bindBillDiscountModel(BillDiscountModel model);

    @FragmentScope
    @Provides
    static List<TagViewItem> provideBillDiscountList(){
        return new ArrayList<>();
    }

    @FragmentScope
    @Provides
    static TagViewAdapter provideBillDiscountAdapter(List<TagViewItem> billDiscountList){
        return new TagViewAdapter(billDiscountList);
    }

}