package com.gingersoft.gsa.cloud.common.printer.plugins;

import android.graphics.Bitmap;

import com.gingersoft.gsa.cloud.database.bean.PrinterDeviceBean;

import java.util.List;
import java.util.Map;

/**
 * @作者: bin
 * @創建時間: 2021-01-25 10:19
 * @更新時間: 2021-01-25 10:19
 * @描述:打印整體打印流程(打印前數據信息,圖片->連接成功(失敗)->打印成功(失敗)->斷開連接)
 */
public interface PrinterFlowListener extends ExternalPrinterConnection {
    /**
     * 打印前，還未生成圖片之前
     *
     * @param orderType
     * @param printType
     * @param printerData
     * @param printerDeviceInfo
     */
    void onPrinterDataBefore(int orderType, int printType, String printerData, String printerDeviceInfo);

    /**
     * 生成圖片之後，打印之前
     *
     * @param orderType
     * @param printType
     * @param directoryName
     * @param bitmaps
     */
    void onPrinterBitmapBefore(int orderType, int printType, String directoryName, List<Bitmap> bitmaps);

    /**
     * 打印之前
     */
    void onPrintSuccess();

    /**
     * 打印失敗
     *
     * @param errorCode 錯誤碼
     */
    void onPrintError(int errorCode);
}
