package com.gingersoft.supply_chain.mvp.ui.adapter;

import android.content.Context;
import android.graphics.Color;
import android.util.Log;
import android.view.View;
import android.widget.CheckBox;
import android.widget.CompoundButton;
import android.widget.LinearLayout;

import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;

import com.chad.library.adapter.base.BaseQuickAdapter;
import com.chad.library.adapter.base.viewholder.BaseViewHolder;
import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.mvp.bean.OrderCategoryBean;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.List;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/1/25
 * Time: 9:20
 * Use:
 */
public class SelectCategoryAdapter extends BaseQuickAdapter<OrderCategoryBean.FoodCategoryTrees, BaseViewHolder> {

    private int bgColor;
    /**
     * 記錄當前第幾級分類
     */
    private int level;

    private OnChildSelectListener onChildSelectListener;
    /**
     * 當前選中的下標集合
     */
    private int[] positions;
    /**
     * 標題的縮進
     */
    private String indentation;

    /**
     * @param data      分類數據
     * @param bgColor   當前背景色
     * @param level     當前是第幾級分類
     * @param positions 選中下標集合 positions[level]表示獲取第level級選中的分類的下標
     */
    public SelectCategoryAdapter(@Nullable List<OrderCategoryBean.FoodCategoryTrees> data, int bgColor, int level, int[] positions) {
        super(R.layout.item_select_category, data);
        this.bgColor = bgColor;
        this.level = level;
        this.positions = positions;
        indentation = "";
    }

    public SelectCategoryAdapter setIndentation(String indentation) {
        this.indentation = indentation;
        return this;
    }

    @Override
    protected void convert(@NotNull BaseViewHolder viewHolder, OrderCategoryBean.FoodCategoryTrees foodCategoryTrees) {
        viewHolder.setText(R.id.tv_radio_section_title, indentation + foodCategoryTrees.getName());
        viewHolder.setBackgroundColor(R.id.layout_item_select_category, bgColor);
        CheckBox checkBox = viewHolder.getView(R.id.cb_radio_section);
        if (level < positions.length) {
            //當前分類已選中，要默認展開
            if (viewHolder.getAdapterPosition() == positions[level]) {
                checkBox.setChecked(true);
                setChildState(viewHolder, foodCategoryTrees, false);
            } else {
                checkBox.setChecked(false);
                viewHolder.setGone(R.id.rv_select_category, true);
            }
        } else {
            checkBox.setChecked(false);
            viewHolder.setGone(R.id.rv_select_category, true);
        }
        //選中狀態切換
        checkBox.setOnCheckedChangeListener((buttonView, isChecked) -> {
            if (buttonView.isPressed()) {
                //將低於此級別的都設置為未選中
                for (int i = level; i < positions.length; i++) {
                    positions[i] = -1;
                }
                if (isChecked) {
                    //沒選中的情況下，才設置為選中
                    //當前級別存下
                    positions[level] = viewHolder.getAdapterPosition();
                } else {
                    positions[level] = -1;
                }
                //通知父類選中或沒選中
                onChildSelectListener.onSelect(viewHolder.getAdapterPosition(), isChecked);
            }
        });
        //設置當前item點擊顯示或隱藏
        LinearLayout layout = viewHolder.getView(R.id.layout_item_select_category);
        layout.setOnClickListener(v -> {
            //顯示就隱藏，隱藏就顯示
            RecyclerView rvNextLevelCategory = viewHolder.getView(R.id.rv_select_category);
            setChildState(viewHolder, foodCategoryTrees, rvNextLevelCategory.getVisibility() == View.VISIBLE);
        });
    }

    /**
     * 子類選中時的接口
     */
    public interface OnChildSelectListener {
        /**
         * 選中時調用
         *
         * @param position  分類下標
         * @param isChecked 選中狀態
         */
        void onSelect(int position, boolean isChecked);
    }

    public void setOnChildSelectListener(OnChildSelectListener onChildSelectListener) {
        this.onChildSelectListener = onChildSelectListener;
    }

    /**
     * 設置子分類顯示狀態
     *
     * @param viewHolder
     * @param foodCategoryTrees 父分類
     */
    private void setChildState(@NotNull BaseViewHolder viewHolder, OrderCategoryBean.FoodCategoryTrees foodCategoryTrees, boolean notShowChild) {
        RecyclerView rvNextLevelCategory = viewHolder.getView(R.id.rv_select_category);
        if (foodCategoryTrees.getFoodCategoryTrees() != null) {
            viewHolder.setGone(R.id.rv_select_category, notShowChild);
            SelectCategoryAdapter selectCategoryAdapter = new SelectCategoryAdapter(foodCategoryTrees.getFoodCategoryTrees(), bgColor == Color.WHITE ? ContextCompat.getColor(getContext(), R.color.color_ccc) : getBgColor(bgColor), level + 1, positions);
            rvNextLevelCategory.setAdapter(selectCategoryAdapter.setIndentation(indentation + "\u3000"));
            selectCategoryAdapter.setOnChildSelectListener((position, isChecked) -> {
                //子類被選中了，父類也要被選中
                positions[level] = viewHolder.getAdapterPosition();
                onChildSelectListener.onSelect(viewHolder.getAdapterPosition(), isChecked);
            });
            rvNextLevelCategory.setTag(selectCategoryAdapter);
        } else {
            viewHolder.setGone(R.id.rv_select_category, true);
        }
    }


    private int getBgColor(int backgroundColor) {
        int alpha = Color.alpha(backgroundColor) + 20;
        int red = Color.red(backgroundColor) + 20;
        int green = Color.green(backgroundColor) + 20;
        int blue = Color.blue(backgroundColor) + 20;
        if (alpha < 0 || alpha > 255) {
            alpha = 0;
        }
        if (red < 0 || red > 255) {
            red = 0;
        }
        if (green < 0 || green > 255) {
            green = 0;
        }
        if (blue < 0 || blue > 255) {
            blue = 0;
        }
        return Color.argb(alpha, red, green, blue);
    }
}
