package com.gingersoft.supply_chain.mvp.ui.widget;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import androidx.recyclerview.widget.RecyclerView;

import com.gingersoft.supply_chain.R;
import com.gingersoft.supply_chain.R2;
import com.gingersoft.supply_chain.mvp.bean.PurchaseFoodEncodeSn;

import java.util.List;

import butterknife.BindView;
import butterknife.ButterKnife;

/**
 * @author 宇航.
 * User: admin
 * Date: 2021/3/18
 * Time: 17:23
 * Use: 掃描sn碼
 */
public class ShowSnView extends FrameLayout {

    private List<PurchaseFoodEncodeSn> snCodes;

    @BindView(R2.id.rv_sn_code)
    RecyclerView rvSnCode;
    @BindView(R2.id.frame_sn_list)
    FrameLayout snListLayout;

    public ShowSnView(Context context, List<PurchaseFoodEncodeSn> snCodes) {
        super(context);
        this.snCodes = snCodes;
        init();
    }

    private void init() {
        View rootView = LayoutInflater.from(getContext()).inflate(R.layout.layout_show_sn, this, false);
        ButterKnife.bind(this, rootView);
        //初始化adapter
        ScanSnView.SnCodeAdapter adapter = new ScanSnView.SnCodeAdapter(R.layout.item_show_sn_code, snCodes);
        rvSnCode.setAdapter(adapter);
        addView(rootView);
    }
}
